/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.menu;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.menu.AbstractClayMenuSlot;
import net.bumblebee.claysoldiers.menu.AbstractClayMobMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractClayMobScreen<C extends ClayMobEntity, T extends AbstractClayMobMenu<C>>
extends AbstractContainerScreen<T> {
    public static final String CLAY_TEAM_LABEL = "gui.label.csr.clay_team";
    public static final String CLAY_TEAM_LOYAL_LABEL = "gui.label.csr.clay_team_loyalty";
    public static final String SLOT_LABEL = "gui.label.csr.slot";
    protected static final int GRAY_COLOR = 0x404040;
    protected int teamPropertiesY = 6;
    protected int teamPropertiesX = 104;

    public AbstractClayMobScreen(T pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        ArrayList<Label> labels = new ArrayList<Label>();
        this.queLabels(labels);
        int labelY = this.teamPropertiesY;
        for (Label label : labels) {
            label.render(pGuiGraphics, this.font, this.teamPropertiesX, labelY);
            labelY += label.height;
        }
    }

    protected Component getTeamLabel(ClayMobEntity clayMob) {
        return Component.translatable((String)CLAY_TEAM_LABEL, (Object[])new Object[]{clayMob.getClayTeam().getDisplayName()});
    }

    protected void queLabels(List<Label> labels) {
        ((AbstractClayMobMenu)this.menu).forSourceIfPresent(clayMob -> {
            if (!clayMob.getType().is(ModTags.EntityTypes.CLAY_BOSS)) {
                labels.add(new Label(this.getTeamLabel((ClayMobEntity)clayMob), clayMob.getTeamColor()));
            }
            if (clayMob.hasClayTeamOwner()) {
                labels.add(new Label((Component)Component.translatable((String)CLAY_TEAM_LOYAL_LABEL, (Object[])new Object[]{clayMob.getOwnerDisplayName()}), 0x404040, 0.75f, 1));
            }
        });
    }

    protected void renderSource(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int scale, float yOffset, int mouseX, int mouseY) {
        ((AbstractClayMobMenu)this.menu).forSourceIfPresent(clayMob -> InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)x1, (int)y1, (int)x2, (int)y2, (int)scale, (float)yOffset, (float)mouseX, (float)mouseY, (LivingEntity)clayMob));
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isHovering(8, 84 + ((AbstractClayMobMenu)this.menu).inventoryYOffset, 161, 75, mouseX, mouseY)) {
            super.renderTooltip(guiGraphics, mouseX, mouseY);
            return;
        }
        if (!((AbstractClayMobMenu)this.menu).getCarried().isEmpty() || this.hoveredSlot == null) {
            return;
        }
        if (this.hoveredSlot.hasItem()) {
            ItemStack itemstack = this.hoveredSlot.getItem();
            this.renderSpecialTooltip(guiGraphics, itemstack, mouseX, mouseY);
        } else {
            Slot slot = this.hoveredSlot;
            if (slot instanceof AbstractClayMenuSlot) {
                AbstractClayMenuSlot clayMenuSlot = (AbstractClayMenuSlot)slot;
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)SLOT_LABEL, (Object[])new Object[]{clayMenuSlot.getDisplayName()}).withStyle(ChatFormatting.GRAY), mouseX, mouseY);
            }
        }
    }

    protected abstract void renderSpecialTooltip(GuiGraphics var1, ItemStack var2, int var3, int var4);

    protected void addItemName(List<Component> tooltip, ItemStack stack) {
        MutableComponent itemName = Component.empty().append(stack.getHoverName()).withStyle(stack.getRarity().color());
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            itemName.withStyle(ChatFormatting.ITALIC);
        }
        tooltip.add((Component)itemName);
    }

    protected void addSlotName(List<Component> tooltip) {
        Slot slot = this.hoveredSlot;
        if (slot instanceof AbstractClayMenuSlot) {
            AbstractClayMenuSlot slot2 = (AbstractClayMenuSlot)slot;
            tooltip.add((Component)Component.translatable((String)SLOT_LABEL, (Object[])new Object[]{slot2.getDisplayName()}).withStyle(ChatFormatting.GRAY));
        }
    }

    public record Label(Component text, int color, float scale, int height) {
        public Label(Component text, int color) {
            this(text, color, 1.0f, 10);
        }

        public void render(GuiGraphics guiGraphics, Font font, int x, int y) {
            if (this.scale != 1.0f) {
                PoseStack pose = guiGraphics.pose();
                pose.pushPose();
                pose.scale(this.scale, this.scale, 1.0f);
                guiGraphics.drawString(font, this.text, (int)((float)x / this.scale), (int)((float)y / this.scale), this.color, false);
                pose.popPose();
            } else {
                guiGraphics.drawString(font, this.text, x, y, this.color, false);
            }
        }
    }
}

