/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.menu.escritoire;

import com.google.common.collect.Lists;
import java.util.List;
import net.bumblebee.claysoldiers.blueprint.BlueprintManager;
import net.bumblebee.claysoldiers.init.ModBlocks;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModMenuTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class EscritoireMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final Level level;
    private final DataSlot selectedRecipeIndex = DataSlot.standalone();
    private Runnable slotUpdateListener = () -> {};
    public final Container container = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            EscritoireMenu.this.slotsChanged((Container)this);
            EscritoireMenu.this.slotUpdateListener.run();
        }
    };
    private final ResultContainer resultContainer = new ResultContainer();
    private final List<ItemStack> recipes = Lists.newArrayList();
    private final Slot inputSlot;
    private ItemStack input = ItemStack.EMPTY;
    private final Slot resultSlot;

    public EscritoireMenu(int containerId, Inventory playerInventory, int data) {
        this(containerId, playerInventory, ContainerLevelAccess.NULL);
    }

    public EscritoireMenu(int containerId, Inventory playerInventory, ContainerLevelAccess access) {
        super(ModMenuTypes.ESCRITOIRE_MENU.get(), containerId);
        this.access = access;
        this.level = playerInventory.player.level();
        this.addDataSlot(this.selectedRecipeIndex);
        this.inputSlot = this.addSlot(new Slot(this, this.container, 0, 20, 33){

            public boolean mayPlace(ItemStack stack) {
                return EscritoireMenu.isValidBlueprintPage(stack);
            }
        });
        this.resultSlot = this.addSlot(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean mayPlace(ItemStack p_40362_) {
                return false;
            }

            public void onTake(Player p_150672_, ItemStack p_150673_) {
                p_150673_.onCraftedBy(p_150672_.level(), p_150672_, p_150673_.getCount());
                EscritoireMenu.this.resultContainer.awardUsedRecipes(p_150672_, this.getRelevantItems());
                ItemStack itemstack = EscritoireMenu.this.inputSlot.remove(1);
                if (!itemstack.isEmpty()) {
                    EscritoireMenu.this.setupResultSlot();
                }
                super.onTake(p_150672_, p_150673_);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(EscritoireMenu.this.inputSlot.getItem());
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
    }

    private void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.get())) {
            ItemStack recipeholder = this.recipes.get(this.selectedRecipeIndex.get()).copy();
            if (recipeholder.isItemEnabled(this.level.enabledFeatures())) {
                this.resultSlot.set(recipeholder);
            } else {
                this.resultSlot.set(ItemStack.EMPTY);
            }
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            Item item = itemstack1.getItem();
            itemstack = itemstack1.copy();
            if (index == 1) {
                item.onCraftedBy(itemstack1, player.level(), player);
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index == 0 ? !this.moveItemStackTo(itemstack1, 2, 38, false) : (EscritoireMenu.isValidBlueprintPage(itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (index >= 2 && index < 29 ? !this.moveItemStackTo(itemstack1, 29, 38, false) : index >= 29 && index < 38 && !this.moveItemStackTo(itemstack1, 2, 29, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
            this.broadcastChanges();
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return EscritoireMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)ModBlocks.ESCRITOIRE_BLOCK.get());
    }

    private static boolean isValidBlueprintPage(ItemStack stack) {
        return stack.is(ModItems.BLUEPRINT_PAGE.get());
    }

    public List<ItemStack> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.get();
    }

    public boolean hasInputItem() {
        return this.inputSlot.hasItem() && !this.recipes.isEmpty();
    }

    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }

    private boolean isValidRecipeIndex(int recipeIndex) {
        return recipeIndex >= 0 && recipeIndex < this.recipes.size();
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.resultContainer && super.canTakeItemForPickAll(stack, slot);
    }

    public void removed(Player player) {
        super.removed(player);
        this.resultContainer.removeItemNoUpdate(1);
        this.access.execute((p_40313_, p_40314_) -> this.clearContainer(player, this.container));
    }

    public boolean clickMenuButton(Player player, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipeIndex.set(id);
            this.setupResultSlot();
        }
        return true;
    }

    public void slotsChanged(Container inventory) {
        ItemStack itemstack = this.inputSlot.getItem();
        if (!itemstack.is(this.input.getItem())) {
            this.input = itemstack.copy();
            this.setupRecipeList(inventory, itemstack);
        }
    }

    private void setupRecipeList(Container container, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipeIndex.set(-1);
        this.resultSlot.set(ItemStack.EMPTY);
        if (!stack.isEmpty() && container.hasAnyMatching(EscritoireMenu::isValidBlueprintPage)) {
            this.recipes.addAll(BlueprintManager.getBlueprintItems((HolderLookup.Provider)this.level.registryAccess()));
        }
    }
}

