/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.menu.horse;

import java.util.Optional;
import net.bumblebee.claysoldiers.entity.horse.AbstractClayHorse;
import net.bumblebee.claysoldiers.init.ModMenuTypes;
import net.bumblebee.claysoldiers.menu.AbstractClayMobMenu;
import net.bumblebee.claysoldiers.menu.horse.ClayHorseSlot;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ClayHorseMenu
extends AbstractClayMobMenu<AbstractClayHorse> {
    @Nullable
    private final AbstractClayHorse horse;

    public ClayHorseMenu(int pContainerId, Inventory inv, int extraData) {
        AbstractClayHorse clayHorse;
        Entity entity = inv.player.level().getEntity(extraData);
        this(pContainerId, inv, entity instanceof AbstractClayHorse ? (clayHorse = (AbstractClayHorse)entity) : null);
    }

    public ClayHorseMenu(int pContainerId, Inventory inv, @Nullable AbstractClayHorse clayHorse) {
        super(ModMenuTypes.CLAY_HORSE_MENU.get(), pContainerId, inv);
        this.horse = clayHorse;
        if (this.horse != null) {
            this.addSlot(ClayHorseSlot.createArmorSlot(this.horse, 8, 36));
        }
        this.initPlayerInventory(inv);
    }

    @Override
    protected Optional<AbstractClayHorse> getSource() {
        return Optional.ofNullable(this.horse);
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        return ItemStack.EMPTY;
    }
}

