/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.menu.soldier;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.ZombieClaySoldierEntity;
import net.bumblebee.claysoldiers.menu.AbstractClayMobScreen;
import net.bumblebee.claysoldiers.menu.soldier.ClaySoldierMenu;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMapReader;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveType;
import net.bumblebee.claysoldiers.util.ComponentFormating;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class ClaySoldierScreen
extends AbstractClayMobScreen<AbstractClaySoldierEntity, ClaySoldierMenu> {
    public static final String PREVIOUS_CLAY_TEAM_LABEL = "gui.label.csr.previous_clay_team";
    public static final String REVIVE_TYPE_COOLDOWN = "gui.label.csr.revive_type_cooldown";
    public static final String REVIVE_TYPE_COOLDOWN_ENTRY = "gui.label.csr.revive_type_cooldown_entry";
    public static final String SOLDIER_PROPERTIES = "gui.label.csr.soldier_properties";
    public static final float REVIVE_SCALE = 0.75f;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"textures/gui/container/clay_soldier_inventory.png");

    public ClaySoldierScreen(ClaySoldierMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.imageHeight = 192;
        this.teamPropertiesY = 16;
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(RenderType::guiTextured, TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight + 2, 256, 256);
        this.renderSource(guiGraphics, x + 26, y + 18, x + 75, y + 78, 60, 0.0625f, pMouseX, pMouseY);
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (this.isHovering(24, 16, 50, 70, pMouseX, pMouseY)) {
            ((ClaySoldierMenu)this.menu).forSourceIfPresent(soldier -> this.renderProperties(pGuiGraphics, soldier.allProperties(), pMouseX, pMouseY));
        }
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
    }

    @Override
    protected void renderSpecialTooltip(GuiGraphics pGuiGraphics, ItemStack stack, int mouseX, int mouseY) {
        SoldierHoldableEffect soldierProperties = ClaySoldiersCommon.DATA_MAP.getEffect(stack);
        if (soldierProperties == null) {
            return;
        }
        ArrayList<Component> tooltip = new ArrayList<Component>();
        this.addItemName(tooltip, stack);
        this.addSlotName(tooltip);
        Component predicateDisplayName = soldierProperties.predicate().getDisplayName();
        ((ClaySoldierMenu)this.menu).forSourceIfPresent(soldier -> {
            ComponentFormating.formatProperties(tooltip, soldierProperties.properties(), List.of(), soldier);
            if (predicateDisplayName != null) {
                tooltip.add(predicateDisplayName);
            }
            pGuiGraphics.renderTooltip(this.font, tooltip, stack.getTooltipImage(), mouseX, mouseY);
        });
    }

    public void renderProperties(GuiGraphics guiGraphics, SoldierPropertyMapReader properties, int pX, int pY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Component.translatable((String)SOLDIER_PROPERTIES).withStyle(ChatFormatting.DARK_GRAY));
        ComponentFormating.formatProperties(tooltip, properties, List.of(SoldierPropertyTypes.ATTACK_TYPE.get()), ((ClaySoldierMenu)this.menu).getSource().orElse(null));
        guiGraphics.renderComponentTooltip(this.font, tooltip, pX, pY);
    }

    @Override
    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        super.renderLabels(pGuiGraphics, pMouseX, pMouseY);
    }

    @Override
    protected void queLabels(List<AbstractClayMobScreen.Label> labels) {
        super.queLabels(labels);
        ((ClaySoldierMenu)this.menu).forSourceIfPresent(claySoldier -> {
            Set<Map.Entry<ReviveType, Integer>> entrySet;
            if (claySoldier instanceof ZombieClaySoldierEntity) {
                ZombieClaySoldierEntity zombie = (ZombieClaySoldierEntity)claySoldier;
                labels.add(1, new AbstractClayMobScreen.Label(ClaySoldierScreen.getZombieTeamLabel(zombie), 0x404040, 0.75f, 6));
            }
            if (!(entrySet = claySoldier.getReviveTypeCooldown().entrySet()).isEmpty()) {
                labels.add(new AbstractClayMobScreen.Label((Component)Component.translatable((String)REVIVE_TYPE_COOLDOWN), 0x404040));
                for (Map.Entry<ReviveType, Integer> entry : entrySet) {
                    labels.add(new AbstractClayMobScreen.Label((Component)Component.translatable((String)REVIVE_TYPE_COOLDOWN_ENTRY, (Object[])new Object[]{entry.getKey().getAnimatedDisplayName((LivingEntity)claySoldier), entry.getValue() / 20}), 0x404040, 0.75f, 10));
                }
            }
        });
    }

    protected static Component getZombieTeamLabel(ZombieClaySoldierEntity zombie) {
        return Component.translatable((String)PREVIOUS_CLAY_TEAM_LABEL, (Object[])new Object[]{zombie.getPreviousTeam().getDisplayNameWithColor(c -> c.getColor((LivingEntity)zombie, 0.0f))});
    }
}

