/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.networking;

import net.bumblebee.claysoldiers.block.blueprint.EaselBlockEntity;
import net.bumblebee.claysoldiers.networking.IClientPayload;
import net.bumblebee.claysoldiers.platform.services.INetworkManger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;

public record BlueprintPlacePayload(BlockPos pos, Item item) implements IClientPayload
{
    public static final CustomPacketPayload.Type<BlueprintPlacePayload> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"blueprint_place"));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlueprintPlacePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, BlueprintPlacePayload::pos, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), BlueprintPlacePayload::item, BlueprintPlacePayload::new);

    @Override
    public void handleClient(INetworkManger.PayloadContext context) {
        BlockEntity blockEntity = context.client().level.getBlockEntity(this.pos);
        if (blockEntity instanceof EaselBlockEntity) {
            EaselBlockEntity easelBlockEntity = (EaselBlockEntity)blockEntity;
            easelBlockEntity.tryPlacingSoldier(this.item.getDefaultInstance(), null);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

