/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.networking;

import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.block.hamsterwheel.IHamsterWheelEnergyStorage;
import net.bumblebee.claysoldiers.networking.IClientPayload;
import net.bumblebee.claysoldiers.platform.services.INetworkManger;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public record HamsterWheelEnergyPayload(long amount, BlockPos pos) implements IClientPayload
{
    public static final CustomPacketPayload.Type<HamsterWheelEnergyPayload> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"hamster_wheel_energy"));
    public static final StreamCodec<RegistryFriendlyByteBuf, HamsterWheelEnergyPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, HamsterWheelEnergyPayload::amount, (StreamCodec)BlockPos.STREAM_CODEC, HamsterWheelEnergyPayload::pos, HamsterWheelEnergyPayload::new);

    @Override
    public void handleClient(INetworkManger.PayloadContext context) {
        HamsterWheelBlockEntity hamsterWheelBlock;
        IHamsterWheelEnergyStorage en;
        BlockEntity blockEntity = context.client().level.getBlockEntity(this.pos);
        if (blockEntity instanceof HamsterWheelBlockEntity && (en = (hamsterWheelBlock = (HamsterWheelBlockEntity)blockEntity).getEnergyStorage(null)) != null) {
            en.setEnergy(this.amount);
        }
    }

    public CustomPacketPayload.Type<? extends HamsterWheelEnergyPayload> type() {
        return ID;
    }
}

