/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.platform;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.datamap.armor.SoldierMultiWearable;
import net.bumblebee.claysoldiers.init.ModDataMaps;
import net.bumblebee.claysoldiers.platform.services.IDataMapGetter;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoi;
import net.bumblebee.claysoldiers.soldierproperties.SoldierVehicleProperties;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoForgeDataMapGetter
implements IDataMapGetter {
    private static Map<SoldierEquipmentSlot, List<Item>> bySlot = new EnumMap<SoldierEquipmentSlot, List<Item>>(SoldierEquipmentSlot.class);

    @Override
    @Nullable
    public SoldierHoldableEffect getEffect(ItemStack stack) {
        return (SoldierHoldableEffect)stack.getItemHolder().getData(ModDataMaps.SOLDIER_HOLDABLE);
    }

    @Override
    @Nullable
    public SoldierHoldableEffect getEffect(Item item) {
        return (SoldierHoldableEffect)item.builtInRegistryHolder().getData(ModDataMaps.SOLDIER_HOLDABLE);
    }

    @Override
    @Nullable
    public SoldierMultiWearable getArmor(ItemStack stack) {
        return (SoldierMultiWearable)stack.getItemHolder().getData(ModDataMaps.SOLDIER_ARMOR);
    }

    @Override
    @Nullable
    public SoldierPoi getItemPoi(ItemStack stack) {
        return (SoldierPoi)stack.getItemHolder().getData(ModDataMaps.SOLDIER_ITEM_POI);
    }

    @Override
    @Nullable
    public SoldierPoi getItemPoi(Item item) {
        return (SoldierPoi)item.builtInRegistryHolder().getData(ModDataMaps.SOLDIER_ITEM_POI);
    }

    @Override
    @Nullable
    public SoldierPoi getBlockPoi(Block block) {
        ResourceKey key = BuiltInRegistries.BLOCK.getResourceKey((Object)block).orElse(null);
        if (key == null) {
            return null;
        }
        return (SoldierPoi)BuiltInRegistries.BLOCK.getData(ModDataMaps.SOLDIER_BLOCK_POI, key);
    }

    @Override
    @Nullable
    public SoldierVehicleProperties getVehicleProperties(EntityType<?> type) {
        return (SoldierVehicleProperties)type.builtInRegistryHolder().getData(ModDataMaps.SOLDIER_VEHICLE_PROPERTIES);
    }

    @Override
    @NotNull
    public List<Item> getHoldableEffectForSlot(SoldierEquipmentSlot slot) {
        return Objects.requireNonNull(bySlot.get(slot));
    }

    public static void setBySlot(Map<SoldierEquipmentSlot, List<Item>> map) {
        bySlot = map;
    }

    public static String getBySlotMap() {
        return bySlot.toString();
    }
}

