/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.platform;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.platform.services.INetworkManger;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class NeoForgeNetworkManger
implements INetworkManger {
    private static final List<INetworkManger.PayloadData<?, ?>> PAYLOAD_DATA = new ArrayList();

    public static <T extends CustomPacketPayload, C extends RegistryFriendlyByteBuf> void forEach(Consumer<INetworkManger.PayloadData<T, C>> consumer) {
        PAYLOAD_DATA.forEach(d -> consumer.accept((INetworkManger.PayloadData)d));
    }

    @Override
    public <T extends CustomPacketPayload, C extends RegistryFriendlyByteBuf> void registerS2CPayload(CustomPacketPayload.Type<T> id, StreamCodec<C, T> codec, BiConsumer<T, INetworkManger.PayloadContext> clientHandler) {
        PAYLOAD_DATA.add(new INetworkManger.PayloadData<T, C>(id, codec, clientHandler));
    }

    @Override
    public void sendToPlayer(ServerPlayer player, CustomPacketPayload payload) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToPlayersTrackingEntity(Entity entity, CustomPacketPayload payload) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToAllPlayers(ServerLevel ignored, CustomPacketPayload payload) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToPlayersTrackingBlockEntity(BlockEntity target, CustomPacketPayload payload) {
        Level level = target.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level2, (ChunkPos)new ChunkPos(target.getBlockPos()), (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            ClaySoldiersCommon.LOGGER.error("Cannot send a Packet to the Server from a Client Side BlockEntity");
        }
    }

    @Override
    public boolean hasChannel(ServerPlayer player, CustomPacketPayload.Type<?> type) {
        return player.connection.hasChannel(type);
    }

    @Override
    public boolean isMemoryConnection(ServerPlayer player) {
        return player.connection.getConnection().isMemoryConnection();
    }
}

