/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.recipe;

import java.util.List;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModRecipes;
import net.bumblebee.claysoldiers.item.BrickedItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrickedItemReviveRecipe
extends CustomRecipe {
    @Nullable
    private PlacementInfo placementInfo;

    public BrickedItemReviveRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(CraftingInput input, Level level) {
        ItemStack itemstack = ItemStack.EMPTY;
        ItemStack ghastTear = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack itemAtI = input.getItem(i);
            if (itemAtI.isEmpty()) continue;
            if (itemAtI.getItem() instanceof BrickedItem) {
                if (!itemstack.isEmpty()) {
                    return false;
                }
                itemstack = itemAtI;
                continue;
            }
            if (!itemAtI.is(Items.GHAST_TEAR)) continue;
            if (!ghastTear.isEmpty()) {
                return false;
            }
            ghastTear = itemAtI;
        }
        return !itemstack.isEmpty() && !ghastTear.isEmpty();
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        for (int i = 0; i < input.size(); ++i) {
            Item item;
            ItemStack itemAtI = input.getItem(i);
            if (itemAtI.isEmpty() || !((item = itemAtI.getItem()) instanceof BrickedItem)) continue;
            BrickedItem brickedItem = (BrickedItem)item;
            return brickedItem.getOriginal(itemAtI);
        }
        throw new IllegalStateException("Crafting: Tried Reviving a Clay Soldier with no BrickedItem");
    }

    public List<RecipeDisplay> display() {
        return List.of(new ShapelessCraftingRecipeDisplay(List.of(new SlotDisplay.ItemSlotDisplay((Item)ModItems.BRICKED_CLAY_SOLDIER.get()), new SlotDisplay.ItemSlotDisplay(Items.GHAST_TEAR)), (SlotDisplay)new SlotDisplay.ItemSlotDisplay((Item)ModItems.CLAY_SOLDIER.get()), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.CRAFTING_TABLE)));
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create(List.of(Ingredient.of((ItemLike)((ItemLike)ModItems.BRICKED_CLAY_SOLDIER.get())), Ingredient.of((ItemLike)Items.GHAST_TEAR)));
        }
        return this.placementInfo;
    }

    public boolean isSpecial() {
        return false;
    }

    @NotNull
    public RecipeSerializer<BrickedItemReviveRecipe> getSerializer() {
        return ModRecipes.CLAY_SOLDIER_REVIVING.get();
    }
}

