/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldieritemtypes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.soldieritemtypes.Generator;
import net.bumblebee.claysoldiers.soldieritemtypes.ItemGenerator;
import net.bumblebee.claysoldiers.soldieritemtypes.WeightedItem;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SoldierItemType {
    public static final Codec<SoldierItemType> CODEC = RecordCodecBuilder.create(in -> in.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(s -> s.tag), (App)ModRegistries.ITEM_GENERATORS_REGISTRY.byNameCodec().fieldOf("generator").forGetter(s -> s.generator), (App)Codec.STRING.optionalFieldOf("name", (Object)"").forGetter(s -> s.name)).apply((Applicative)in, SoldierItemType::new));
    public static final String LANG = "clay_soldier_item_type";
    private static final Logger LOGGER = ClaySoldiersCommon.LOGGER;
    @Nullable
    private static Runnable dataMapLoad = null;
    @Nullable
    private static Runnable postTagLoad = null;
    private static List<Generator> types;
    private final TagKey<Item> tag;
    private final ItemGenerator generator;
    private List<WeightedItem> available;
    @Nullable
    private String descriptionId;
    private final String name;

    public SoldierItemType(TagKey<Item> tag, ItemGenerator generator) {
        this(tag, generator, "");
    }

    public SoldierItemType(TagKey<Item> tag, ItemGenerator generator, String name) {
        this.tag = tag;
        this.generator = generator;
        this.name = name;
    }

    public static void onDataMapLoad(@NotNull Runnable runnable) {
        dataMapLoad = () -> {
            runnable.run();
            ClaySoldiersCommon.LOGGER.info("SoldierItemTypes: Weight finalized");
        };
        ClaySoldiersCommon.LOGGER.info("Datamap Loaded {}", (Object)(postTagLoad == null ? "Tags Not Loaded" : "Tags Loaded"));
        if (postTagLoad != null) {
            dataMapLoad.run();
            dataMapLoad = null;
            postTagLoad.run();
            postTagLoad = null;
        }
    }

    public static void onTagLoad(HolderLookup.Provider registries) {
        HolderLookup.RegistryLookup reg = registries.lookupOrThrow(ModRegistries.SOLDIER_ITEM_TYPES);
        reg.listElements().forEach(type -> ((SoldierItemType)type.value()).onTagLoad(tag -> registries.lookupOrThrow(Registries.ITEM).get(tag)));
        if (dataMapLoad != null) {
            SoldierItemType.postTagLoad(reg.listElements().map(Holder::value));
            dataMapLoad.run();
            dataMapLoad = null;
        } else {
            postTagLoad = () -> SoldierItemType.postTagLoad(reg.listElements().map(Holder::value));
        }
    }

    private static void postTagLoad(Stream<SoldierItemType> all) {
        ClaySoldiersCommon.LOGGER.info("Post Tag Loaded");
        types = all.filter(s -> !s.available.isEmpty() && s.generator.limitedBy() != ItemGenerator.Limit.ZERO).map(SoldierItemType::asGenerator).toList();
    }

    public void onTagLoad(Function<TagKey<Item>, Optional<HolderSet.Named<Item>>> tagGetter) {
        Optional<HolderSet.Named<Item>> opt = tagGetter.apply(this.tag);
        opt.ifPresentOrElse(holderSet -> {
            this.available = holderSet.stream().map(h -> new WeightedItem((Item)h.value())).toList();
        }, () -> {
            this.available = List.of();
            LOGGER.warn("Tag {} for SoldierItemType {} not present", this.tag, (Object)this.name);
        });
    }

    public void afterDataMapLoad() {
        if (this.available == null) {
            throw new IllegalStateException("Cannot complete SoldierItemType before tags are loaded");
        }
        this.available = this.available.stream().filter(w -> w.finalizeWeight() > 0.0f).toList();
    }

    public boolean isEmpty() {
        return this.available.isEmpty();
    }

    private Generator asGenerator() {
        return new Generator(){

            @Override
            public NonNullList<ItemStack> generateForTag(int count, RandomSource random) {
                return SoldierItemType.this.generator.generateForTag(SoldierItemType.this.available, count, random);
            }

            @Override
            public ItemGenerator.Limit limitedBy() {
                return SoldierItemType.this.generator.limitedBy();
            }
        };
    }

    public NonNullList<ItemStack> getItems(RandomSource random, int count) {
        if (this.available == null || types == null) {
            throw new IllegalStateException("Tried to generate items before tag loading");
        }
        return this.generator.generate(this.available, count, random, types);
    }

    public String toString() {
        return "SoldierItemType(%s)[%s]".formatted(this.generator, this.available != null ? Integer.valueOf(this.available.size()) : "null");
    }

    public Component getDisplayName() {
        if (!this.name.isEmpty()) {
            return Component.literal((String)this.name);
        }
        return this.descriptionId != null ? Component.translatable((String)this.descriptionId) : Component.literal((String)"[unregistered]");
    }

    public void onRegister(ResourceLocation id) {
        this.descriptionId = Util.makeDescriptionId((String)LANG, (ResourceLocation)id);
    }
}

