/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldieritemtypes;

import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WeightedItem {
    private final Item item;
    private FloatSupplier weightGetter;
    private float weight = -1.0f;

    public WeightedItem(Item item) {
        this.item = item;
        this.weightGetter = () -> WeightedItem.getWeight(item);
    }

    public float getWeight() {
        return this.weight;
    }

    public Item getItem() {
        return this.item;
    }

    public ItemStack asStack() {
        return this.item.getDefaultInstance();
    }

    public String toString() {
        return "%s(%.2f)".formatted(this.item, Float.valueOf(this.weight));
    }

    private static float getWeight(Item item) {
        SoldierHoldableEffect eff = ClaySoldiersCommon.DATA_MAP.getEffect(item);
        return eff == null ? 0.0f : 1.0f / (float)(eff.pickUpPriority() - -3 + 1);
    }

    public float finalizeWeight() {
        this.weight = this.weightGetter.getAsFloat();
        this.weightGetter = null;
        return this.weight;
    }

    @FunctionalInterface
    private static interface FloatSupplier {
        public float getAsFloat();
    }
}

