/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierpoi;

import java.util.Comparator;
import java.util.EnumSet;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoiWithBlock;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoiWithSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class FindNearestPoiGoal
extends Goal {
    private static final int DEFAULT_RANDOM_INTERVAL = 60;
    private static final int SEARCH_RANGE = 10;
    private static final int VERTICAL_SEARCH_RANGE = 4;
    private static final int VERTICAL_SEARCH_START = 0;
    protected final int randomInterval;
    private final AbstractClaySoldierEntity clayMob;
    @Nullable
    private SoldierPoiWithSource<?> target = null;

    public FindNearestPoiGoal(AbstractClaySoldierEntity clayMob, int randomInterval) {
        this.clayMob = clayMob;
        this.randomInterval = randomInterval;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public FindNearestPoiGoal(AbstractClaySoldierEntity clayMob) {
        this(clayMob, 60);
    }

    public boolean canUse() {
        if (this.clayMob.hasControllingPassenger()) {
            return false;
        }
        if (this.randomInterval > 0 && this.clayMob.getRandom().nextInt(this.randomInterval) != 0) {
            return false;
        }
        this.findNearestPoi();
        return this.target != null;
    }

    public boolean canContinueToUse() {
        return !this.clayMob.getNavigation().isDone() && !this.clayMob.hasControllingPassenger();
    }

    public void start() {
        assert (this.target != null);
        this.target.startPath(this.clayMob.getNavigation());
    }

    public void stop() {
        assert (this.target != null);
        this.target.performEffect(this.clayMob);
        this.target = null;
        this.clayMob.getNavigation().stop();
        super.stop();
    }

    private void findNearestPoi() {
        SoldierPoiWithSource itemPoi = this.clayMob.level().getEntitiesOfClass(ItemEntity.class, this.getTargetSearchArea(this.getFollowDistance())).stream().map(this::getPoiWithPos).filter(this::canUsePoi).min(this.sortDistance()).orElse(null);
        if (itemPoi != null) {
            this.target = itemPoi;
            return;
        }
        this.target = this.findNearestBlock();
    }

    private SoldierPoiWithSource<ItemEntity> getPoiWithPos(ItemEntity entity) {
        return SoldierPoiWithSource.getPoiFromItem(entity);
    }

    protected AABB getTargetSearchArea(double pTargetDistance) {
        return this.clayMob.getBoundingBox().inflate(pTargetDistance, 4.0, pTargetDistance);
    }

    private Comparator<SoldierPoiWithSource<ItemEntity>> sortDistance() {
        return (p1, p2) -> (int)(this.clayMob.distanceToSqr((Entity)p1.getSource()) - this.clayMob.distanceToSqr((Entity)p2.getSource()));
    }

    private double getFollowDistance() {
        return this.clayMob.getAttributeValue(Attributes.FOLLOW_RANGE);
    }

    private boolean canUsePoi(SoldierPoiWithSource<?> poi) {
        return poi.canPerformEffect(this.clayMob);
    }

    @Nullable
    protected SoldierPoiWithBlock findNearestBlock() {
        BlockPos blockpos = this.clayMob.blockPosition();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int ySearch = 0;
        while (ySearch <= 4) {
            for (int l = 0; l < 10; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        SoldierPoiWithBlock poi;
                        blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, i1, ySearch - 1, j1);
                        BlockState state = this.clayMob.level().getBlockState((BlockPos)blockpos$mutableblockpos);
                        if (!state.isAir() && this.clayMob.isWithinRestriction((BlockPos)blockpos$mutableblockpos) && this.canUsePoi(poi = new SoldierPoiWithBlock(state.getBlock(), (BlockPos)blockpos$mutableblockpos))) {
                            return poi;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            ySearch = ySearch > 0 ? -ySearch : 1 - ySearch;
        }
        return null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

