/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierpoi;

import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiSource;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.networking.ClayMobItemBreakParticles;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoiWithSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.pathfinder.Path;

public class SoldierPoiWithBlock
extends SoldierPoiWithSource<BlockPoiData> {
    public SoldierPoiWithBlock(Block block, BlockPos pos) {
        this(new BlockPoiData(block, pos));
    }

    private SoldierPoiWithBlock(BlockPoiData data) {
        super(ClaySoldiersCommon.DATA_MAP.getBlockPoi(data.block), data);
    }

    @Override
    protected ClayPoiSource createPoiSource(BlockPoiData source) {
        return ClayPoiSource.createSource(source.block);
    }

    @Override
    public void animateEffect(ClayMobEntity claySoldier) {
        ClaySoldiersCommon.NETWORK_MANGER.sendToPlayersTrackingEntity((Entity)claySoldier, new ClayMobItemBreakParticles(claySoldier.getId(), ((BlockPoiData)this.getSource()).asItem()));
    }

    @Override
    public void startPath(PathNavigation navigation) {
        Path path = navigation.createPath(((BlockPoiData)this.getSource()).pos, 0);
        navigation.moveTo(path, 1.3);
    }

    @Override
    public void onUse(BlockPoiData source, AbstractClaySoldierEntity soldier) {
        assert (this.getPoi() != null);
        float breakChance = this.getPoi().getBreakChance();
        if (breakChance <= 0.0f) {
            return;
        }
        if (soldier.level().isClientSide()) {
            return;
        }
        if (soldier.getRandom().nextFloat() <= breakChance) {
            soldier.level().destroyBlock(source.pos, false, (Entity)soldier);
        }
    }

    @Override
    protected SoldierPoiWithSource.Type getType() {
        return SoldierPoiWithSource.Type.BLOCK;
    }

    @Override
    protected boolean stillValid(AbstractClaySoldierEntity soldier) {
        return soldier.level().getBlockState(((BlockPoiData)this.getSource()).pos).is(((BlockPoiData)this.getSource()).block);
    }

    public record BlockPoiData(Block block, BlockPos pos) {
        public Item asItem() {
            return this.block.asItem();
        }
    }
}

