/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierpoi;

import com.mojang.serialization.Codec;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiSource;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClaySoldierInventoryQuery;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModCriterions;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoi;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoiWithItem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import org.jetbrains.annotations.Nullable;

public abstract class SoldierPoiWithSource<T> {
    @Nullable
    private final SoldierPoi poi;
    private final T source;

    public SoldierPoiWithSource(@Nullable SoldierPoi poi, T source) {
        this.poi = poi;
        this.source = source;
    }

    public static SoldierPoiWithSource<ItemEntity> getPoiFromItem(ItemEntity itemEntity) {
        return new SoldierPoiWithItem(itemEntity);
    }

    @Nullable
    public SoldierPoi getPoi() {
        return this.poi;
    }

    public T getSource() {
        return this.source;
    }

    public void performEffect(AbstractClaySoldierEntity soldier) {
        if (this.poi != null && this.stillValid(soldier)) {
            ClayPoiSource createdSource = this.createPoiSource(this.source);
            Entity entity = createdSource.getOwner();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ModCriterions.SOLDIER_POI_USE_TRIGGER.get().trigger(serverPlayer, this.getType());
            }
            this.poi.performEffect(soldier, createdSource);
            this.animateEffect(soldier);
            this.onUse(this.source, soldier);
        }
    }

    protected abstract ClayPoiSource createPoiSource(T var1);

    protected boolean stillValid(AbstractClaySoldierEntity soldier) {
        return true;
    }

    public abstract void animateEffect(ClayMobEntity var1);

    public boolean canPerformEffect(ClaySoldierInventoryQuery soldier) {
        if (this.poi == null) {
            return false;
        }
        return this.poi.canPerformEffect(soldier);
    }

    public abstract void startPath(PathNavigation var1);

    public abstract void onUse(T var1, AbstractClaySoldierEntity var2);

    public String toString() {
        return "SoldierPoiWithSource{" + String.valueOf(this.poi) + ", " + String.valueOf(this.source) + "}";
    }

    protected abstract Type getType();

    public static enum Type implements StringRepresentable
    {
        ITEM("item"),
        BLOCK("block");

        public static final Codec<Type> CODEC;
        private final String serializedName;

        private Type(String serializedName) {
            this.serializedName = serializedName;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }
}

