/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.soldierproperties.SoldierProperty;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMapReader;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.DamageBlock;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.DeathCloudProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.IEvacuationProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.RangedAttackType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.UnitProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.WraithProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.effectimmunity.EffectImmunityMap;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.effectimmunity.EffectImmunityType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttack;
import net.bumblebee.claysoldiers.soldierproperties.types.UnitPropertyType;
import net.bumblebee.claysoldiers.util.codec.SoldierPropertyMapCodec;
import net.bumblebee.claysoldiers.util.codec.SoldierPropertyMapStreamCodec;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.NotNull;

public class SoldierPropertyMap
implements SoldierPropertyMapReader {
    public static final Set<Supplier<? extends SoldierPropertyType<?>>> IGNORED_NON_ITEM = new HashSet<Supplier<SoldierPropertyType<RangedAttackType>>>(Set.of(SoldierPropertyTypes.ATTACK_TYPE, SoldierPropertyTypes.EVACUATION, SoldierPropertyTypes.THROWABLE));
    public static final Codec<SoldierPropertyMap> CODEC = new SoldierPropertyMapCodec();
    public static final Codec<SoldierPropertyMap> CODEC_FOR_NON_ITEM = new SoldierPropertyMapCodec(IGNORED_NON_ITEM);
    public static final StreamCodec<RegistryFriendlyByteBuf, SoldierPropertyMap> STREAM_CODEC = new SoldierPropertyMapStreamCodec();
    public static final SoldierPropertyMap EMPTY_MAP = new SoldierPropertyMap(null, s -> Set.of());
    private final Set<SoldierProperty<?>> set;

    private <T> SoldierPropertyMap(T collection, Function<T, Set<SoldierProperty<?>>> factory) {
        this.set = factory.apply(collection);
    }

    public SoldierPropertyMap() {
        this.set = new HashSet();
    }

    public SoldierPropertyMap(Collection<? extends SoldierProperty<?>> collection) {
        this(collection, HashSet::new);
    }

    public static SoldierPropertyMap of(SoldierProperty<?> ... properties) {
        return new SoldierPropertyMap(properties, Set::of);
    }

    public <T> boolean addPropertyForce(SoldierPropertyType<T> identifier, T value) {
        return this.addPropertyForce(new SoldierProperty<T>(identifier, value));
    }

    public boolean addPropertyForce(SoldierProperty<?> property) {
        this.set.remove(property);
        return this.set.add(property);
    }

    protected <K, V> void appendMapProperty(SoldierPropertyType<Map<K, V>> type, K key, V value) {
        Map<K, V> map = this.getValueOrNull(type);
        if (map == null) {
            map = new HashMap();
            this.addPropertyForce(type, map);
        }
        map.put(key, value);
    }

    protected <T> void appendListProperty(SoldierPropertyType<List<T>> type, T value) {
        List<Object> list;
        if (this.hasPropertyType(type)) {
            list = this.getValueOrDfault(type);
        } else {
            list = new ArrayList();
            this.addPropertyForce(type, list);
        }
        list.add(value);
    }

    @Override
    public <T> SoldierProperty<T> getProperty(SoldierPropertyType<T> type) {
        for (SoldierProperty<?> property : this.set) {
            if (!property.type().equals(type)) continue;
            return property;
        }
        return null;
    }

    @Override
    public <T> T getValueOrNull(SoldierPropertyType<T> type) {
        for (SoldierProperty<?> property : this.set) {
            if (!property.type().equals(type)) continue;
            return (T)property.value();
        }
        return null;
    }

    @Override
    @NotNull
    public Iterator<SoldierProperty<?>> iterator() {
        return this.set.iterator();
    }

    @Override
    public Spliterator<SoldierProperty<?>> spliterator() {
        return this.set.spliterator();
    }

    public String toString() {
        return "SoldierPropertyMap" + String.valueOf(this.set);
    }

    public void validate(Consumer<IllegalStateException> exceptionHandler) {
        switch (this.getValueOrDfault(SoldierPropertyTypes.THROWABLE.get())) {
            case HARM: {
                if (!this.attackType().isSupportive()) break;
                exceptionHandler.accept(new IllegalStateException("Cannot have a harmful ranged attack with an supportive attack type"));
                break;
            }
            case HELPING: {
                if (this.attackType().isSupportive()) break;
                exceptionHandler.accept(new IllegalStateException("Cannot have a supportive ranged attack with an non supportive attack type"));
            }
        }
    }

    public void clear() {
        this.set.clear();
    }

    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final SoldierPropertyMap map = new SoldierPropertyMap();

        public Builder setDamage(float damage) {
            return this.addProperty(SoldierPropertyTypes.DAMAGE, Float.valueOf(damage));
        }

        public Builder setProtection(float protection) {
            return this.addProperty(SoldierPropertyTypes.PROTECTION, Float.valueOf(protection));
        }

        public Builder setExplosionResistance(float protection) {
            return this.addProperty(SoldierPropertyTypes.EXPLOSION_RESISTANCE, Float.valueOf(protection));
        }

        public Builder setSetOnFire(int sec) {
            return this.addProperty(SoldierPropertyTypes.SET_ON_FIRE, sec);
        }

        public Builder throwable(RangedAttackType type) {
            return this.addProperty(SoldierPropertyTypes.THROWABLE, type);
        }

        public Builder throwable(RangedAttackType type, float damage) {
            return this.throwable(type).setDamage(damage);
        }

        public Builder setSeeInvis() {
            return this.addUnitProperty(SoldierPropertyTypes.SEE_INVISIBILITY);
        }

        public Builder setCanSwim() {
            return this.addUnitProperty(SoldierPropertyTypes.CAN_SWIM);
        }

        public Builder setBreathHold(int holdBreath) {
            return this.addProperty(SoldierPropertyTypes.BREATH_HOLD, holdBreath);
        }

        public Builder infiniteBreathHold() {
            return this.setBreathHold(1000);
        }

        public Builder noBreathHold() {
            return this.setBreathHold(-200);
        }

        public Builder explosion(float power) {
            return this.addProperty(SoldierPropertyTypes.DEATH_EXPLOSION, Float.valueOf(power));
        }

        public Builder size(float size) {
            return this.addProperty(SoldierPropertyTypes.SIZE, Float.valueOf(size));
        }

        public Builder glowOutline() {
            return this.addUnitProperty(SoldierPropertyTypes.GLOW_OUTLINE);
        }

        public Builder glowing() {
            return this.addUnitProperty(SoldierPropertyTypes.GLOW_IN_THE_DARK);
        }

        public Builder invisible() {
            return this.addUnitProperty(SoldierPropertyTypes.INVISIBLE);
        }

        public Builder addAttribute(Holder<Attribute> attribute, AttributeModifier modifier) {
            this.map.appendMapProperty(SoldierPropertyTypes.ATTRIBUTES.get(), attribute, List.of(modifier));
            return this;
        }

        public Builder addDeathCloudEffect(DeathCloudProperty deathCloudEffect) {
            this.map.appendListProperty(SoldierPropertyTypes.DEATH_CLOUD.get(), deathCloudEffect);
            return this;
        }

        public Builder attackType(AttackTypeProperty type) {
            return this.addProperty(SoldierPropertyTypes.ATTACK_TYPE, type);
        }

        public Builder heavy(float toughness) {
            return this.addProperty(SoldierPropertyTypes.HEAVY, Float.valueOf(toughness));
        }

        public Builder addSpecialAttack(SpecialAttack<?> type) {
            this.map.appendListProperty(SoldierPropertyTypes.SPECIAL_ATTACK.get(), type);
            return this;
        }

        public Builder addCounterAttack(SpecialAttack<?> type) {
            this.map.appendListProperty(SoldierPropertyTypes.COUNTER_ATTACK.get(), type);
            return this;
        }

        public Builder damageBlock(float amount, float chance, boolean pierceable) {
            return this.addProperty(SoldierPropertyTypes.DAMAGE_BLOCK, new DamageBlock(amount, chance, pierceable));
        }

        public Builder damageBlock(float chance, float amount) {
            return this.damageBlock(amount, chance, true);
        }

        public Builder canReviveOther(ReviveProperty reviveProperty) {
            return this.addProperty(SoldierPropertyTypes.REVIVE_PROPERTY, reviveProperty);
        }

        public Builder immunity(Holder<MobEffect> effect, EffectImmunityType type) {
            EffectImmunityMap effectMap;
            if (this.map.hasPropertyType(SoldierPropertyTypes.IMMUNITY.get())) {
                effectMap = this.map.getValueOrDfault(SoldierPropertyTypes.IMMUNITY.get());
            } else {
                effectMap = new EffectImmunityMap();
                this.map.addPropertyForce(SoldierPropertyTypes.IMMUNITY.get(), effectMap);
            }
            effectMap.put(effect, type);
            return this;
        }

        public Builder wraith(WraithProperty wraith) {
            return this.addProperty(SoldierPropertyTypes.WRAITH, wraith);
        }

        public Builder bonusAttackRange(float bonusRange) {
            return this.addProperty(SoldierPropertyTypes.ATTACK_RANGE, Float.valueOf(bonusRange));
        }

        public Builder allowGliding() {
            return this.addUnitProperty(SoldierPropertyTypes.CAN_GLIDE);
        }

        public Builder allowTeleporting() {
            return this.addUnitProperty(SoldierPropertyTypes.TELEPORTATION);
        }

        public Builder setTeleportingToOwner() {
            return this.addUnitProperty(SoldierPropertyTypes.TELEPORT_TO_OWNER);
        }

        public Builder setEvacuation(IEvacuationProperty evacuation) {
            return this.addProperty(SoldierPropertyTypes.EVACUATION, evacuation);
        }

        public Builder canBounce() {
            return this.addUnitProperty(SoldierPropertyTypes.BOUNCE);
        }

        public Builder setBreakingPower(int breakingPower) {
            return this.addProperty(SoldierPropertyTypes.BREAKING_POWER, breakingPower);
        }

        public Builder addUnitProperty(Supplier<UnitPropertyType> unit) {
            return this.addProperty(unit, UnitProperty.INSTANCE);
        }

        public <V, T extends SoldierPropertyType<V>> Builder addProperty(Supplier<T> type, V value) {
            this.map.addPropertyForce((SoldierPropertyType)type.get(), value);
            return this;
        }

        public SoldierPropertyMap build() {
            this.map.validate(this::throwException);
            return this.map;
        }

        private void throwException(IllegalStateException exception) {
            throw exception;
        }
    }
}

