/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.soldierproperties.SoldierProperty;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.DamageBlock;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.DeathCloudProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.IEvacuationProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.RangedAttackType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.WraithProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.effectimmunity.EffectImmunityMap;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttack;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttackType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public interface SoldierPropertyMapReader
extends Iterable<SoldierProperty<?>> {
    public static final SoldierPropertyMapReader EMPTY = new SoldierPropertyMapReader(){

        @Override
        @Nullable
        public <T> SoldierProperty<T> getProperty(SoldierPropertyType<T> type) {
            return null;
        }

        @Override
        @Nullable
        public <T> T getValueOrNull(SoldierPropertyType<T> type) {
            return null;
        }

        @Override
        @NotNull
        public Iterator<SoldierProperty<?>> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };

    @Nullable
    public <T> SoldierProperty<T> getProperty(SoldierPropertyType<T> var1);

    @Nullable
    public <T> T getValueOrNull(SoldierPropertyType<T> var1);

    default public <T> T getValueOrDfault(SoldierPropertyType<T> type) {
        T value = this.getValueOrNull(type);
        return value != null ? value : type.getDefaultValue();
    }

    default public <T> T getValueOrDfault(Supplier<SoldierPropertyType<T>> type) {
        return this.getValueOrDfault(type.get());
    }

    default public <T> boolean hasPropertyType(SoldierPropertyType<T> type) {
        return this.getValueOrNull(type) != null;
    }

    default public <T> int getPropertyValueAsInt(SoldierPropertyType<T> type) {
        return type.applyAsInt(this.getValueOrDfault(type));
    }

    default public float damage() {
        return ((Float)this.getValueOrDfault(SoldierPropertyTypes.DAMAGE)).floatValue();
    }

    default public float protection() {
        return ((Float)this.getValueOrDfault(SoldierPropertyTypes.PROTECTION)).floatValue();
    }

    default public float explosionResistance() {
        return ((Float)this.getValueOrDfault(SoldierPropertyTypes.EXPLOSION_RESISTANCE)).floatValue();
    }

    default public int setOnFire() {
        return (Integer)this.getValueOrDfault(SoldierPropertyTypes.SET_ON_FIRE);
    }

    default public RangedAttackType throwable() {
        return (RangedAttackType)this.getValueOrDfault(SoldierPropertyTypes.THROWABLE);
    }

    default public boolean canSwim() {
        return this.hasPropertyType(SoldierPropertyTypes.CAN_SWIM.get());
    }

    default public boolean canSeeInvis() {
        return this.hasPropertyType(SoldierPropertyTypes.SEE_INVISIBILITY.get());
    }

    default public int breathHoldDuration() {
        return (Integer)this.getValueOrDfault(SoldierPropertyTypes.BREATH_HOLD.get());
    }

    default public float getSoldierSize() {
        return ((Float)this.getValueOrDfault(SoldierPropertyTypes.SIZE)).floatValue();
    }

    default public boolean isInvisible() {
        return this.hasPropertyType(SoldierPropertyTypes.INVISIBLE.get());
    }

    default public boolean hasGlowOutline() {
        return this.hasPropertyType(SoldierPropertyTypes.GLOW_OUTLINE.get());
    }

    default public boolean isGlowing() {
        return this.hasPropertyType(SoldierPropertyTypes.GLOW_IN_THE_DARK.get());
    }

    default public AttackTypeProperty attackType() {
        return (AttackTypeProperty)this.getValueOrDfault(SoldierPropertyTypes.ATTACK_TYPE);
    }

    default public float heavy() {
        return ((Float)this.getValueOrDfault(SoldierPropertyTypes.HEAVY)).floatValue();
    }

    default public @UnmodifiableView List<SpecialAttack<?>> specialAttacks(SpecialAttackType type, SpecialEffectCategory category) {
        return ((List)this.getValueOrDfault(SoldierPropertyTypes.SPECIAL_ATTACK)).stream().filter(s -> s.getAttackType().is(type)).filter(s -> s.isForCategory(category)).toList();
    }

    default public @UnmodifiableView List<SpecialAttack<?>> counterAttacks(SpecialAttackType type) {
        return ((List)this.getValueOrDfault(SoldierPropertyTypes.COUNTER_ATTACK)).stream().filter(s -> s.getAttackType().is(type)).filter(s -> s.isForCategory(SpecialEffectCategory.HARMFUL)).toList();
    }

    default public @UnmodifiableView List<MobEffectInstance> getDeathCloudEffects() {
        return ((List)this.getValueOrDfault(SoldierPropertyTypes.DEATH_CLOUD)).stream().map(DeathCloudProperty::asInstance).toList();
    }

    default public DamageBlock damageBlock() {
        return (DamageBlock)this.getValueOrDfault(SoldierPropertyTypes.DAMAGE_BLOCK);
    }

    default public ReviveProperty reviveType() {
        return (ReviveProperty)this.getValueOrDfault(SoldierPropertyTypes.REVIVE_PROPERTY);
    }

    default public EffectImmunityMap immunity() {
        return (EffectImmunityMap)this.getValueOrDfault(SoldierPropertyTypes.IMMUNITY);
    }

    @Nullable
    default public WraithProperty wraith() {
        return this.getValueOrNull(SoldierPropertyTypes.WRAITH.get());
    }

    default public float bonusAttackRange() {
        return ((Float)this.getValueOrDfault(SoldierPropertyTypes.ATTACK_RANGE)).floatValue();
    }

    default public boolean canGlide() {
        return this.hasPropertyType(SoldierPropertyTypes.CAN_GLIDE.get());
    }

    default public boolean canTeleport() {
        return this.hasPropertyType(SoldierPropertyTypes.TELEPORTATION.get());
    }

    default public boolean canTeleportToOwner() {
        return this.hasPropertyType(SoldierPropertyTypes.TELEPORT_TO_OWNER.get());
    }

    default public IEvacuationProperty getEvacuationProperty() {
        return this.getValueOrDfault(SoldierPropertyTypes.EVACUATION.get());
    }

    default public boolean hasEvacuationProperty() {
        IEvacuationProperty value = this.getValueOrNull(SoldierPropertyTypes.EVACUATION.get());
        return value != null && !value.isEmpty();
    }

    default public boolean canBounce() {
        return this.hasPropertyType(SoldierPropertyTypes.BOUNCE.get());
    }

    default public int getBreakingPower() {
        return (Integer)this.getValueOrDfault(SoldierPropertyTypes.BREAKING_POWER);
    }

    @Override
    @NotNull
    public Iterator<SoldierProperty<?>> iterator();

    public boolean isEmpty();
}

