/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClaySoldierInventoryQuery;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.soldierproperties.SoldierProperty;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public class SoldierPropertyType<T>
implements ToIntFunction<T>,
ValueCombiner<T> {
    private final Codec<T> valueCodec;
    private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;
    private final T defaultValue;
    private final ToIntFunction<T> toIntFunction;
    private final ValueCombiner<T> combiner;
    private Holder.Reference<SoldierPropertyType<?>> holder;
    @Nullable
    private String descriptionId;
    @Nullable
    private final BiFunction<String, T, List<Component>> customDisplayName;

    protected SoldierPropertyType(Codec<T> valueCodec, StreamCodec<RegistryFriendlyByteBuf, T> streamCodec, T defaultValue, ToIntFunction<T> toIntFunction, ValueCombiner<T> combiner, @Nullable BiFunction<String, T, List<Component>> customDisplayName) {
        this.valueCodec = valueCodec;
        this.streamCodec = streamCodec;
        this.defaultValue = defaultValue;
        this.toIntFunction = toIntFunction;
        this.combiner = combiner;
        this.customDisplayName = customDisplayName;
    }

    public Codec<T> getValueCodec() {
        return this.valueCodec;
    }

    public void streamEncode(RegistryFriendlyByteBuf byteBuff, T value) {
        this.streamCodec.encode((Object)byteBuff, value);
    }

    public T streamDecode(RegistryFriendlyByteBuf byteBuff) {
        return (T)this.streamCodec.decode((Object)byteBuff);
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public int applyAsInt(T value) {
        return this.toIntFunction.applyAsInt(value);
    }

    @Override
    public T combine(T first, T second) {
        return this.combiner.combine(first, second);
    }

    public String getDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.makeDescriptionId((String)"clay_soldier_property", (ResourceLocation)this.getOrCreateReference().key().location());
        }
        return this.descriptionId;
    }

    public SoldierProperty<T> createProperty(T value) {
        return new SoldierProperty<T>(this, value);
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getDescriptionId());
    }

    public List<Component> getDisplayNameWithValue(T value, @Nullable ClaySoldierInventoryQuery soldier) {
        if (this.customDisplayName == null) {
            return List.of(Component.translatable((String)this.getDescriptionId()).append(": " + String.valueOf(value)));
        }
        return this.customDisplayName.apply(this.getDescriptionId(), (String)value);
    }

    public String toString() {
        return ModRegistries.SOLDIER_PROPERTY_TYPES_REGISTRY.getKey((Object)this).getPath();
    }

    public boolean is(TagKey<SoldierPropertyType<?>> tag) {
        return this.getOrCreateReference().is(tag);
    }

    private Holder.Reference<SoldierPropertyType<?>> getOrCreateReference() {
        if (this.holder == null) {
            this.holder = (Holder.Reference)ModRegistries.SOLDIER_PROPERTY_TYPES_REGISTRY.get(ResourceKey.create(ModRegistries.SOLDIER_PROPERTY_TYPES, (ResourceLocation)ModRegistries.SOLDIER_PROPERTY_TYPES_REGISTRY.getKey((Object)this))).orElseThrow();
        }
        return this.holder;
    }
}

