/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.customproperties;

import com.mojang.serialization.Codec;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialEffectCategory;
import net.bumblebee.claysoldiers.soldierproperties.translation.KeyableTranslatableProperty;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public enum AttackTypeProperty implements StringRepresentable,
KeyableTranslatableProperty
{
    NORMAL("normal", true, true, true, AttackTypeProperty::shouldAttackClaySoldier, null),
    PACIFIST("pacifist", false, true, true, (s, t) -> false, ChatFormatting.WHITE),
    AGGRESSIVE("aggressive", true, false, false, AttackTypeProperty::canSeeTarget, ChatFormatting.DARK_RED),
    SUPPORT("support", false, true, true, AttackTypeProperty::healerPredicate, ChatFormatting.GREEN),
    KING("king", true, false, true, AttackTypeProperty::royaltyPredicate, ChatFormatting.GOLD),
    QUEEN("queen", true, false, true, AttackTypeProperty::royaltyPredicate, ChatFormatting.AQUA),
    ZOMBIE("zombie", true, false, false, AttackTypeProperty::shouldAttackClaySoldier, ChatFormatting.DARK_GREEN),
    VAMPIRE("vampire", true, false, false, AttackTypeProperty::shouldAttackClaySoldier, null){

        @Override
        public Style getStyle() {
            return Style.EMPTY.withColor(0x660707);
        }

        @Override
        public Style getAnimatedStyle(LivingEntity livingEntity) {
            return Style.EMPTY.withColor(0x660707 + (AttackTypeProperty.triangleWave(livingEntity.tickCount, 48) << 16));
        }

        @Override
        public Component getAnimatedDisplayName(LivingEntity livingEntity) {
            return Component.translatable((String)this.translatableKey()).withStyle(this.getAnimatedStyle(livingEntity));
        }
    }
    ,
    BOSS("boss", true, false, false, null, ChatFormatting.WHITE){

        @Override
        public boolean canAttack(AbstractClaySoldierEntity attacker, LivingEntity target) {
            if (target.getType().is(ModTags.EntityTypes.CLAY_BOSS)) {
                return false;
            }
            return target instanceof Player || target instanceof ClayMobEntity;
        }

        @Override
        public Style getAnimatedStyle(LivingEntity livingEntity) {
            if (livingEntity instanceof ClayMobEntity) {
                ClayMobEntity clayMobEntity = (ClayMobEntity)livingEntity;
                return Style.EMPTY.withColor(clayMobEntity.getClayTeam().getColor(livingEntity, 0.0f));
            }
            return super.getAnimatedStyle(livingEntity);
        }

        @Override
        public Component getAnimatedDisplayName(LivingEntity livingEntity) {
            return Component.translatable((String)this.translatableKey()).withStyle(this.getAnimatedStyle(livingEntity));
        }
    };

    private static AttackTypeProperty[] withOutBoss;
    public static final Codec<AttackTypeProperty> CODEC;
    public static final StreamCodec<FriendlyByteBuf, AttackTypeProperty> STREAM_CODEC;
    public static final ToIntFunction<AttackTypeProperty> TO_INT;
    public static final ValueCombiner<AttackTypeProperty> COMBINER;
    private final String serializedName;
    private final boolean fightsBack;
    private final boolean canBeRidden;
    private final boolean canBeRevived;
    private final ClaySoldierTargetPredicate targetPredicate;
    private final ChatFormatting chatFormatting;

    private AttackTypeProperty(String serializedName, boolean fightsBack, boolean canBeRidden, boolean canBeRevived, ClaySoldierTargetPredicate targetPredicate, ChatFormatting chatFormatting) {
        this.serializedName = serializedName;
        this.fightsBack = fightsBack;
        this.canBeRidden = canBeRidden;
        this.canBeRevived = canBeRevived;
        this.targetPredicate = targetPredicate;
        this.chatFormatting = chatFormatting;
    }

    public boolean fightsBack() {
        return this.fightsBack;
    }

    public boolean compatibleWith(AttackTypeProperty attackType) {
        return this == attackType || this == NORMAL || attackType == NORMAL;
    }

    public boolean isRoyalty() {
        return this == QUEEN || this == KING;
    }

    public boolean rideable() {
        return this.canBeRidden;
    }

    public boolean isSupportive() {
        return this == SUPPORT;
    }

    public boolean canWork() {
        return this == PACIFIST;
    }

    public boolean canBeRevived() {
        return this.canBeRevived;
    }

    public SpecialEffectCategory forType() {
        return this.isSupportive() ? SpecialEffectCategory.BENEFICIAL : SpecialEffectCategory.HARMFUL;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public boolean canAttack(AbstractClaySoldierEntity attacker, LivingEntity target) {
        if (!(target instanceof ClayMobEntity)) {
            return false;
        }
        ClayMobEntity clayMobEntity = (ClayMobEntity)target;
        return this.targetPredicate.canAttack(attacker, clayMobEntity);
    }

    private static boolean shouldAttackClaySoldier(AbstractClaySoldierEntity self, ClayMobEntity target) {
        AbstractClaySoldierEntity claySoldier;
        if (!AttackTypeProperty.canSeeTarget(self, target)) {
            return false;
        }
        if (target instanceof AbstractClaySoldierEntity && (claySoldier = (AbstractClaySoldierEntity)target).getAttackType() == AGGRESSIVE) {
            return true;
        }
        return self.shouldAttackTeamHolder(target);
    }

    private static boolean canSeeTarget(AbstractClaySoldierEntity self, ClayMobEntity target) {
        return !target.isInvisible() || target.isCurrentlyGlowing() || self.canSeeInvis();
    }

    private static boolean healerPredicate(AbstractClaySoldierEntity self, ClayMobEntity target) {
        AbstractClaySoldierEntity claySoldier;
        if (target instanceof AbstractClaySoldierEntity && (claySoldier = (AbstractClaySoldierEntity)target).getAttackType() == AGGRESSIVE) {
            return false;
        }
        return self.sameTeamAs((Entity)target);
    }

    private static boolean royaltyPredicate(AbstractClaySoldierEntity self, ClayMobEntity target) {
        if (target instanceof AbstractClaySoldierEntity) {
            AbstractClaySoldierEntity soldierEntity = (AbstractClaySoldierEntity)target;
            if (self.getAttackType() == soldierEntity.getAttackType()) {
                return true;
            }
        }
        if (self.getAttackType() == QUEEN) {
            return false;
        }
        return AttackTypeProperty.shouldAttackClaySoldier(self, target);
    }

    @Override
    public String translatableKey() {
        return "clay_soldier_property.csr.attack_type." + this.serializedName;
    }

    @Override
    public ChatFormatting getFormat() {
        return this.chatFormatting;
    }

    @Override
    @Nullable
    public Component getDisplayName() {
        return KeyableTranslatableProperty.super.getDisplayName();
    }

    @Nullable
    public Style getAnimatedStyle(LivingEntity livingEntity) {
        return this.getStyle();
    }

    private static int triangleWave(int tick, int max) {
        int period = 2 * max;
        int mod = tick % period;
        if (mod <= max) {
            return mod;
        }
        return period - mod;
    }

    private static AttackTypeProperty[] withOutBoss() {
        if (withOutBoss == null) {
            withOutBoss = new AttackTypeProperty[]{NORMAL, PACIFIST, AGGRESSIVE, SUPPORT, KING, QUEEN, ZOMBIE, VAMPIRE};
        }
        return withOutBoss;
    }

    static {
        CODEC = StringRepresentable.fromEnum(AttackTypeProperty::withOutBoss);
        STREAM_CODEC = CodecUtils.createEnumStreamCodec(AttackTypeProperty.class);
        TO_INT = Enum::ordinal;
        COMBINER = (t1, t2) -> {
            if (!t1.compatibleWith((AttackTypeProperty)t2)) {
                throw new IllegalArgumentException("Cannot Combine Attack Type %s with %s".formatted(t1, t2));
            }
            return t1 != NORMAL ? t1 : t2;
        };
    }

    @FunctionalInterface
    public static interface ClaySoldierTargetPredicate {
        public boolean canAttack(AbstractClaySoldierEntity var1, ClayMobEntity var2);
    }
}

