/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.customproperties;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.Level;

public interface IEvacuationProperty {
    public static final String EVACUATION_PROPERTY_PREFIX = "clay_soldier_property.csr..evacuation.";
    public static final Codec<IEvacuationProperty> CODEC = EvacuationProperty.CODEC.flatComapMap(e -> e, IEvacuationProperty::decode);
    public static final StreamCodec<ByteBuf, IEvacuationProperty> STREAM_CODEC = new StreamCodec<ByteBuf, IEvacuationProperty>(){

        public IEvacuationProperty decode(ByteBuf byteBuf) {
            return EvacuationProperty.values()[byteBuf.readByte()];
        }

        public void encode(ByteBuf o, IEvacuationProperty iEvacuationProperty) {
            o.writeByte(Math.max(iEvacuationProperty.id(), 0));
        }
    };
    public static final IEvacuationProperty NONE = EvacuationProperty.NONE;
    public static final IEvacuationProperty FIREWORK = EvacuationProperty.FIREWORK;
    public static final ValueCombiner<IEvacuationProperty> COMBINER = (first, second) -> {
        if (first instanceof CombinedEvacuationProperty) {
            CombinedEvacuationProperty combined1 = (CombinedEvacuationProperty)first;
            return combined1.append((IEvacuationProperty)second);
        }
        if (second instanceof CombinedEvacuationProperty) {
            CombinedEvacuationProperty comnined2 = (CombinedEvacuationProperty)second;
            return comnined2.append((IEvacuationProperty)first);
        }
        return new CombinedEvacuationProperty((IEvacuationProperty)first, (IEvacuationProperty)second);
    };
    public static final BiFunction<String, IEvacuationProperty, List<Component>> DISPLAY_NAME_GETTER = (key, property) -> {
        if (property instanceof CombinedEvacuationProperty) {
            return List.of(Component.translatable((String)key), property.getDisplayName());
        }
        return List.of(property.getDisplayName());
    };

    public void evacuate(ServerLevel var1, ClayMobEntity var2);

    public int id();

    public Component getDisplayName();

    public boolean isEmpty();

    public int toInt();

    private static DataResult<EvacuationProperty> decode(IEvacuationProperty iEvacuationProperty) {
        if (iEvacuationProperty.id() < 0 || iEvacuationProperty.id() >= EvacuationProperty.values().length) {
            return DataResult.error(() -> "Cannot Decode EvacuationProperty with id " + iEvacuationProperty.id());
        }
        return DataResult.success((Object)EvacuationProperty.values()[iEvacuationProperty.id()]);
    }

    public static enum EvacuationProperty implements StringRepresentable,
    IEvacuationProperty
    {
        NONE("none", (s, c) -> {}),
        FIREWORK("firework", EvacuationProperty::evacuateFirework);

        public static final Codec<EvacuationProperty> CODEC;
        private final String serializedName;
        private final BiConsumer<ServerLevel, ClayMobEntity> evacuationFunction;

        private EvacuationProperty(String serializedName, BiConsumer<ServerLevel, ClayMobEntity> evacuationFunction) {
            this.serializedName = serializedName;
            this.evacuationFunction = evacuationFunction;
        }

        @Override
        public void evacuate(ServerLevel level, ClayMobEntity entity) {
            this.evacuationFunction.accept(level, entity);
        }

        private static void evacuateFirework(ServerLevel level, ClayMobEntity shooter) {
            shooter.stopRiding();
            ItemStack stack = Items.FIREWORK_ROCKET.getDefaultInstance();
            stack.set(DataComponents.FIREWORKS, (Object)new Fireworks(1, List.of()));
            FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity((Level)level, (Entity)shooter, shooter.getX(), shooter.getY(), shooter.getZ(), stack);
            level.addFreshEntity((Entity)fireworkrocketentity);
            shooter.startRiding((Entity)fireworkrocketentity, true);
        }

        @Override
        public int id() {
            return this.ordinal();
        }

        @Override
        public int toInt() {
            return 1;
        }

        @Override
        public Component getDisplayName() {
            return Component.translatable((String)this.translatableKey());
        }

        public String translatableKey() {
            return IEvacuationProperty.EVACUATION_PROPERTY_PREFIX + this.serializedName;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        @Override
        public boolean isEmpty() {
            return this == NONE;
        }

        static {
            CODEC = StringRepresentable.fromEnum(EvacuationProperty::values);
        }
    }

    public static class CombinedEvacuationProperty
    implements IEvacuationProperty {
        private final List<IEvacuationProperty> evacs = new ArrayList<IEvacuationProperty>();

        public CombinedEvacuationProperty(IEvacuationProperty first, IEvacuationProperty second) {
            this.evacs.add(first);
            this.evacs.add(second);
        }

        private IEvacuationProperty append(IEvacuationProperty property) {
            if (property instanceof CombinedEvacuationProperty) {
                CombinedEvacuationProperty combined = (CombinedEvacuationProperty)property;
                this.evacs.addAll(combined.evacs);
            } else {
                this.evacs.add(property);
            }
            return this;
        }

        @Override
        public void evacuate(ServerLevel level, ClayMobEntity shooter) {
            this.evacs.getFirst().evacuate(level, shooter);
        }

        @Override
        public int id() {
            return -1;
        }

        @Override
        public Component getDisplayName() {
            MutableComponent start = Component.literal((String)"[");
            for (int i = 0; i < this.evacs.size(); ++i) {
                if (i != 0) {
                    start.append((Component)Component.literal((String)", "));
                }
                start.append(this.evacs.get(i).getDisplayName());
            }
            start.append((Component)Component.literal((String)"]"));
            return start;
        }

        @Override
        public int toInt() {
            return this.evacs.size();
        }

        @Override
        public boolean isEmpty() {
            return this.evacs.isEmpty();
        }
    }
}

