/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.customproperties;

import com.mojang.serialization.Codec;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.bumblebee.claysoldiers.soldierproperties.translation.KeyableTranslatableProperty;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.Nullable;

public enum RangedAttackType implements StringRepresentable,
KeyableTranslatableProperty
{
    NONE("none", null),
    HARM("harmful", ChatFormatting.RED),
    HELPING("helping", ChatFormatting.GREEN);

    public static final Codec<RangedAttackType> CODEC;
    public static final StreamCodec<FriendlyByteBuf, RangedAttackType> STREAM_CODEC;
    public static final ToIntFunction<RangedAttackType> TO_INT;
    public static final ValueCombiner<RangedAttackType> COMBINER;
    public static final String RANGED_ATTACK_TYPE = "clay_soldier_property.csr.ranged_attack";
    private final String serializedName;
    @Nullable
    private final ChatFormatting chatFormatting;

    private RangedAttackType(String serializedName, ChatFormatting chatFormatting) {
        this.serializedName = serializedName;
        this.chatFormatting = chatFormatting;
    }

    public boolean canPerformRangedAttack() {
        return this != NONE;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public String toString() {
        return this.serializedName;
    }

    @Override
    @Nullable
    public Component getDisplayName() {
        Component displayName = KeyableTranslatableProperty.super.getDisplayName();
        if (displayName == null) {
            return null;
        }
        return Component.translatable((String)RANGED_ATTACK_TYPE).append(": ").append(displayName);
    }

    @Override
    public ChatFormatting getFormat() {
        return this.chatFormatting;
    }

    @Override
    public String translatableKey() {
        return "clay_soldier_property.csr.ranged_attack_type." + this.serializedName;
    }

    static {
        CODEC = StringRepresentable.fromEnum(RangedAttackType::values);
        STREAM_CODEC = CodecUtils.createEnumStreamCodec(RangedAttackType.class);
        TO_INT = Enum::ordinal;
        COMBINER = (r1, r2) -> r1 != NONE ? r1 : r2;
    }
}

