/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttackSerializer;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttackType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialEffectCategory;
import net.bumblebee.claysoldiers.soldierproperties.translation.ITranslatableProperty;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class SpecialAttack<T extends SpecialAttack<T>>
implements ITranslatableProperty {
    public static final Codec<SpecialAttack<?>> CODEC = SpecialAttackSerializer.CODEC.dispatch(SpecialAttack::specialAttack, SpecialAttackSerializer::asMapCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, SpecialAttack<?>> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SpecialAttack<?>>(){

        public SpecialAttack<?> decode(RegistryFriendlyByteBuf byteBuf) {
            return (SpecialAttack)((SpecialAttackSerializer)SpecialAttackSerializer.STREAM_CODEC.decode((Object)byteBuf)).getStreamCodec().decode((Object)byteBuf);
        }

        public void encode(RegistryFriendlyByteBuf o, SpecialAttack<?> clayPoiFunction) {
            SpecialAttackSerializer.STREAM_CODEC.encode((Object)o, clayPoiFunction.specialAttack());
            clayPoiFunction.encode(o);
        }
    };
    public static final Codec<List<SpecialAttack<?>>> LIST_CODEC = CodecUtils.getSingleOrListCodec(CODEC);
    public static final ValueCombiner<List<SpecialAttack<?>>> COMBINER = (l1, l2) -> {
        ArrayList newList = new ArrayList(l1);
        newList.addAll(l2);
        return newList;
    };
    public static final ToIntFunction<List<SpecialAttack<?>>> TO_INT = List::size;
    protected static final String DISPLAY_KEY_PREFIX = "clay_soldier_property.csr.special_attack.";
    private final Supplier<SpecialAttackSerializer<T>> serializerGetter;
    private final float bonusDamage;
    private final SpecialAttackType attackType;

    public SpecialAttack(Supplier<SpecialAttackSerializer<T>> serializerGetter, SpecialAttackType attackType, float bonusDamage) {
        this.serializerGetter = serializerGetter;
        this.bonusDamage = bonusDamage;
        this.attackType = attackType;
    }

    public SpecialAttackSerializer<T> specialAttack() {
        return this.serializerGetter.get();
    }

    protected float getDamage() {
        return this.bonusDamage;
    }

    public SpecialAttackType getAttackType() {
        return this.attackType;
    }

    public boolean isForCategory(SpecialEffectCategory category) {
        return category.isHarmful();
    }

    public boolean shouldAttackTarget(LivingEntity target) {
        return true;
    }

    public boolean condition(LivingEntity attacker, Entity target) {
        return true;
    }

    public void attackEffect(LivingEntity attacker, Entity target) {
    }

    public float getBonusDamage(LivingEntity attacker, Entity target) {
        return this.condition(attacker, target) ? this.bonusDamage : 0.0f;
    }

    public void performAttackEffect(LivingEntity attacker, Entity target) {
        if (this.condition(attacker, target)) {
            this.attackEffect(attacker, target);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getAttackType().getSerializedName() + ")" + this.bonusDamageToString();
    }

    protected final String bonusDamageToString() {
        return this.bonusDamage != 0.0f ? " Damage: " + this.bonusDamage : "";
    }

    protected static <P extends SpecialAttack<P>> Codec<P> createDefaultDamageCodec(BiFunction<SpecialAttackType, Float, P> instantiation) {
        return RecordCodecBuilder.create(in -> in.group((App)SpecialAttackType.CODEC.fieldOf("attack_type").forGetter(SpecialAttack::getAttackType), (App)Codec.FLOAT.fieldOf("damage").forGetter(SpecialAttack::getDamage)).apply((Applicative)in, instantiation));
    }

    protected static <P extends SpecialAttack<P>> StreamCodec<RegistryFriendlyByteBuf, P> createDefaultStreamCodec(BiFunction<SpecialAttackType, Float, P> instantiation) {
        return StreamCodec.composite(SpecialAttackType.STREAM_CODEC, SpecialAttack::getAttackType, (StreamCodec)ByteBufCodecs.FLOAT, SpecialAttack::getDamage, instantiation);
    }

    @Override
    @Nullable
    public Component getDisplayName() {
        return Component.literal((String)this.toString());
    }

    private void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
        this.specialAttack().getStreamCodec().encode((Object)registryFriendlyByteBuf, (Object)this);
    }
}

