/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.ZombieClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModEffects;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttack;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttackSerializer;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttackType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialEffectCategory;
import net.bumblebee.claysoldiers.util.EffectHolder;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class SpecialAttacks {
    private static final Supplier<SpecialAttackSerializer<Thorns>> THORNS_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerSpecialAttackSerializer("thorns", () -> new SpecialAttackSerializer<Thorns>(Thorns.CODEC, Thorns.STREAM_CODEC));
    private static final Supplier<SpecialAttackSerializer<SneakAttack>> SNEAK_ATTACK_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerSpecialAttackSerializer("sneak_attack", () -> new SpecialAttackSerializer<SneakAttack>(SneakAttack.CODEC, SneakAttack.STREAM_CODEC));
    private static final Supplier<SpecialAttackSerializer<LightningAttack>> LIGHTNING_ATTACK_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerSpecialAttackSerializer("lightning_attack", () -> new SpecialAttackSerializer<LightningAttack>(LightningAttack.CODEC, LightningAttack.STREAM_CODEC));
    private static final Supplier<SpecialAttackSerializer<EffectAttack>> EFFECT_ATTACK_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerSpecialAttackSerializer("effect", () -> new SpecialAttackSerializer<EffectAttack>(EffectAttack.CODEC, EffectAttack.STREAM_CODEC));
    private static final Supplier<SpecialAttackSerializer<CritAttack>> CRIT_ATTACK_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerSpecialAttackSerializer("critical_hit", () -> new SpecialAttackSerializer<CritAttack>(CritAttack.CODEC, CritAttack.STREAM_CODEC));
    private static final Supplier<SpecialAttackSerializer<Smite>> SMITE_ATTACK_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerSpecialAttackSerializer("smite", () -> new SpecialAttackSerializer<Smite>(Smite.CODEC, Smite.STREAM_CODEC));
    private static final Supplier<SpecialAttackSerializer<Ignite>> IGNITE_ATTACK_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerSpecialAttackSerializer("ignite", () -> new SpecialAttackSerializer<Ignite>(Ignite.CODEC, Ignite.STREAM_CODEC));

    public static void init() {
    }

    public static class Ignite
    extends SpecialAttack<Ignite>
    implements ValueCombiner<Ignite> {
        public static final Codec<Ignite> CODEC = RecordCodecBuilder.create(in -> in.group((App)SpecialAttackType.CODEC.fieldOf("attack_type").forGetter(SpecialAttack::getAttackType), (App)Codec.FLOAT.optionalFieldOf("damage", (Object)Float.valueOf(0.0f)).forGetter(SpecialAttack::getDamage), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("duration").forGetter(c -> c.duration)).apply((Applicative)in, Ignite::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Ignite> STREAM_CODEC = StreamCodec.composite(SpecialAttackType.STREAM_CODEC, SpecialAttack::getAttackType, (StreamCodec)ByteBufCodecs.FLOAT, SpecialAttack::getDamage, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.duration, Ignite::new);
        public static final String DISPLAY_NAME_KEY = "clay_soldier_property.csr.special_attack.ignite";
        private final int duration;

        public Ignite(SpecialAttackType attackType, float bonusDamage, int duration) {
            super(IGNITE_ATTACK_SERIALIZER, attackType, bonusDamage);
            this.duration = duration;
        }

        @Override
        public void attackEffect(LivingEntity attacker, Entity target) {
            target.igniteForTicks(this.duration);
        }

        @Override
        @Nullable
        public Component getDisplayName() {
            return Component.translatable((String)DISPLAY_NAME_KEY, (Object[])new Object[]{Float.valueOf((float)this.duration / 20.0f)}).withStyle(ChatFormatting.GOLD);
        }

        @Override
        public Ignite combine(Ignite first, Ignite second) {
            return new Ignite(first.getAttackType(), first.getDamage() + second.getDamage(), first.duration + second.duration);
        }
    }

    public static class Smite
    extends SpecialAttack<Smite> {
        public static final Codec<Smite> CODEC = SpecialAttack.createDefaultDamageCodec(Smite::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, Smite> STREAM_CODEC = Smite.createDefaultStreamCodec(Smite::new);
        public static final String DISPLAY_NAME_KEY = "clay_soldier_property.csr.special_attack.smite";

        public Smite(SpecialAttackType attackType, float bonusDamage) {
            super(SMITE_ATTACK_SERIALIZER, attackType, bonusDamage);
        }

        @Override
        public boolean condition(LivingEntity attacker, Entity target) {
            return target.getType().is(EntityTypeTags.UNDEAD);
        }

        @Override
        public void attackEffect(LivingEntity attacker, Entity target) {
            if (target instanceof ZombieClaySoldierEntity) {
                ClayMobEntity clayMob;
                ZombieClaySoldierEntity zombie = (ZombieClaySoldierEntity)target;
                if (attacker instanceof ClayMobEntity && zombie.previousTeamSameAs(clayMob = (ClayMobEntity)attacker)) {
                    zombie.cureZombieSoldier();
                }
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                livingEntity.removeEffect(ModEffects.VAMPIRE_CONVERSION);
            }
        }

        @Override
        public boolean shouldAttackTarget(LivingEntity target) {
            return target.getType().is(EntityTypeTags.UNDEAD);
        }

        @Override
        @Nullable
        public Component getDisplayName() {
            return Component.translatable((String)DISPLAY_NAME_KEY).withStyle(ChatFormatting.YELLOW);
        }
    }

    public static class CritAttack
    extends SpecialAttack<CritAttack> {
        public static final Codec<CritAttack> CODEC = RecordCodecBuilder.create(in -> in.group((App)SpecialAttackType.CODEC.fieldOf("attack_type").forGetter(SpecialAttack::getAttackType), (App)Codec.FLOAT.optionalFieldOf("damage", (Object)Float.valueOf(0.0f)).forGetter(SpecialAttack::getDamage), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(0.5f)).forGetter(c -> Float.valueOf(c.chance))).apply((Applicative)in, CritAttack::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CritAttack> STREAM_CODEC = StreamCodec.composite(SpecialAttackType.STREAM_CODEC, SpecialAttack::getAttackType, (StreamCodec)ByteBufCodecs.FLOAT, SpecialAttack::getDamage, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.chance), CritAttack::new);
        public static final String DISPLAY_NAME_KEY = "clay_soldier_property.csr.special_attack.crit";
        private final float chance;

        public CritAttack(SpecialAttackType attackType, float bonusDamage, float chance) {
            super(CRIT_ATTACK_SERIALIZER, attackType, bonusDamage);
            this.chance = chance;
        }

        @Override
        public boolean condition(LivingEntity attacker, Entity target) {
            return attacker.getRandom().nextFloat() >= this.chance;
        }

        @Override
        @Nullable
        public Component getDisplayName() {
            return Component.translatable((String)DISPLAY_NAME_KEY);
        }
    }

    public static class EffectAttack
    extends SpecialAttack<EffectAttack>
    implements EffectHolder {
        public static final Codec<EffectAttack> CODEC = RecordCodecBuilder.create(in -> in.group((App)SpecialAttackType.CODEC.fieldOf("attack_type").forGetter(SpecialAttack::getAttackType), (App)Codec.FLOAT.optionalFieldOf("damage", (Object)Float.valueOf(0.0f)).forGetter(SpecialAttack::getDamage)).and(CodecUtils.addEffectAnd()).apply((Applicative)in, EffectAttack::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, EffectAttack> STREAM_CODEC = StreamCodec.composite(SpecialAttackType.STREAM_CODEC, SpecialAttack::getAttackType, (StreamCodec)ByteBufCodecs.FLOAT, SpecialAttack::getDamage, (StreamCodec)MobEffect.STREAM_CODEC, EffectAttack::effectHolder, (StreamCodec)ByteBufCodecs.VAR_INT, EffectAttack::duration, (StreamCodec)ByteBufCodecs.VAR_INT, EffectAttack::amplifier, EffectAttack::new);
        public static final String DISPLAY_NAME_KEY = "clay_soldier_property.csr.special_attack.effect";
        private final Holder<MobEffect> effect;
        private final int duration;
        private final int amplifier;

        public EffectAttack(SpecialAttackType specialAttackType, float bonusDamage, Holder<MobEffect> effect, int duration, int amplifier) {
            super(EFFECT_ATTACK_SERIALIZER, specialAttackType, bonusDamage);
            this.effect = effect;
            this.duration = duration;
            this.amplifier = amplifier;
        }

        @Override
        public void attackEffect(LivingEntity attacker, Entity target) {
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                livingTarget.addEffect(new MobEffectInstance(this.effect, this.duration, this.amplifier, false, true, true));
            }
        }

        @Override
        public boolean isForCategory(SpecialEffectCategory category) {
            return switch (((MobEffect)this.effect.value()).getCategory()) {
                default -> throw new MatchException(null, null);
                case MobEffectCategory.NEUTRAL -> true;
                case MobEffectCategory.BENEFICIAL -> category.isSupportive();
                case MobEffectCategory.HARMFUL -> category.isHarmful();
            };
        }

        @Override
        public boolean shouldAttackTarget(LivingEntity target) {
            return !target.hasEffect(this.effect);
        }

        @Override
        public Holder<MobEffect> effectHolder() {
            return this.effect;
        }

        @Override
        public int duration() {
            return this.duration;
        }

        @Override
        public int amplifier() {
            return this.amplifier;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.effectHolderToString();
        }

        @Override
        @Nullable
        public Component getDisplayName() {
            return Component.translatable((String)DISPLAY_NAME_KEY).append(" ").append(this.effect().getDisplayName()).withColor(this.effect().getColor());
        }
    }

    public static class LightningAttack
    extends SpecialAttack<LightningAttack> {
        public static final Codec<LightningAttack> CODEC = LightningAttack.createDefaultDamageCodec(LightningAttack::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, LightningAttack> STREAM_CODEC = LightningAttack.createDefaultStreamCodec(LightningAttack::new);
        public static final String DISPLAY_NAME_KEY = "clay_soldier_property.csr.special_attack.lightning";

        public LightningAttack(SpecialAttackType attackType, float bonusDamage) {
            super(LIGHTNING_ATTACK_SERIALIZER, attackType, bonusDamage);
        }

        @Override
        public void attackEffect(LivingEntity attacker, Entity target) {
            ServerLevel serverLevel;
            LightningBolt lightningbolt;
            Level level = attacker.level();
            if (level instanceof ServerLevel && (lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)(serverLevel = (ServerLevel)level), EntitySpawnReason.TRIGGERED)) != null) {
                lightningbolt.moveTo(Vec3.atBottomCenterOf((Vec3i)target.blockPosition()));
                lightningbolt.setVisualOnly(true);
                serverLevel.addFreshEntity((Entity)lightningbolt);
                attacker.playSound((SoundEvent)SoundEvents.TRIDENT_THUNDER.value(), 0.5f, 1.0f);
            }
        }

        @Override
        @Nullable
        public Component getDisplayName() {
            return Component.translatable((String)DISPLAY_NAME_KEY).withStyle(ChatFormatting.WHITE);
        }
    }

    public static class SneakAttack
    extends SpecialAttack<SneakAttack> {
        public static final Codec<SneakAttack> CODEC = SneakAttack.createDefaultDamageCodec(SneakAttack::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, SneakAttack> STREAM_CODEC = SneakAttack.createDefaultStreamCodec(SneakAttack::new);
        public static final String DISPLAY_NAME_KEY = "clay_soldier_property.csr.special_attack.sneak_attack";

        public SneakAttack(SpecialAttackType attackType, float bonusDamage) {
            super(SNEAK_ATTACK_SERIALIZER, attackType, bonusDamage);
        }

        @Override
        public void attackEffect(LivingEntity attacker, Entity target) {
            Level level = attacker.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, target.getX(), target.getY(0.1), target.getZ(), 1, 0.1, 0.0, 0.1, 0.2);
            }
        }

        @Override
        public boolean condition(LivingEntity attacker, Entity target) {
            return attacker.isInvisible();
        }

        @Override
        @Nullable
        public Component getDisplayName() {
            return Component.translatable((String)DISPLAY_NAME_KEY);
        }
    }

    public static class Thorns
    extends SpecialAttack<Thorns> {
        public static final Codec<Thorns> CODEC = Thorns.createDefaultDamageCodec(Thorns::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, Thorns> STREAM_CODEC = Thorns.createDefaultStreamCodec(Thorns::new);
        public static final String DISPLAY_NAME_KEY = "clay_soldier_property.csr.special_attack.thorns";

        public Thorns(SpecialAttackType attackType, float reflectDamage) {
            super(THORNS_SERIALIZER, attackType, reflectDamage);
        }

        @Override
        public boolean condition(LivingEntity attacker, Entity target) {
            return attacker.getRandom().nextFloat() < 0.75f;
        }

        @Override
        @Nullable
        public Component getDisplayName() {
            return Component.translatable((String)DISPLAY_NAME_KEY).withStyle(ChatFormatting.DARK_GREEN);
        }
    }
}

