/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.team;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.item.claymobspawn.ClaySoldierSpawnItem;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.IClayMobTeamReference;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClayMobTeamManger {
    public static final ResourceLocation DEFAULT_TYPE = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"normal");
    public static final ResourceLocation NO_TEAM_TYPE = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"no_team");
    private static final ClayMobTeam DEFAULT = ClayMobTeam.of("Normal", ColorHelper.EMPTY).build();
    private static final ClayMobTeam NO_TEAM = ClayMobTeam.of("NoTeam", ColorHelper.EMPTY).allowFriendlyFire().disableTaming().build();
    private static final Map<Item, ResourceLocation> FROM_ITEM_MAP = new HashMap<Item, ResourceLocation>();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Clay Soldiers Team Manger");
    public static final ClayMobTeam ERROR = new ErrorClayMobTeam();

    public static IClayMobTeamReference getReferenceOrDefault(ResourceLocation key, RegistryAccess access, Runnable ifInValid) {
        Optional holder = access.lookupOrThrow(ModRegistries.CLAY_MOB_TEAMS).get(key);
        if (holder.isPresent()) {
            return new ClayMobTeamReference((Holder.Reference<ClayMobTeam>)((Holder.Reference)holder.orElseThrow()));
        }
        ifInValid.run();
        return new ClayMobTeamReference(ClayMobTeamManger.getDefault((HolderLookup.Provider)access));
    }

    public static Holder.Reference<ClayMobTeam> getDefault(HolderLookup.Provider access) {
        return (Holder.Reference)access.lookupOrThrow(ModRegistries.CLAY_MOB_TEAMS).get(ResourceKey.create(ModRegistries.CLAY_MOB_TEAMS, (ResourceLocation)DEFAULT_TYPE)).orElseThrow();
    }

    public static Stream<ResourceLocation> getAllKeys(HolderLookup.Provider registryAccess) {
        return registryAccess.lookupOrThrow(ModRegistries.CLAY_MOB_TEAMS).listElementIds().map(ResourceKey::location);
    }

    @NotNull
    public static ClayMobTeam getFromKeyAssumeValid(ResourceLocation key, RegistryAccess access) {
        return Objects.requireNonNull((ClayMobTeam)access.lookupOrThrow(ModRegistries.CLAY_MOB_TEAMS).getValue(key), "Tried accessing in valid team");
    }

    @Nullable
    public static ClayMobTeam getFromKey(ResourceLocation key, RegistryAccess registryAccess) {
        return (ClayMobTeam)registryAccess.lookupOrThrow(ModRegistries.CLAY_MOB_TEAMS).getValue(key);
    }

    public static Optional<ClayMobTeam> getOptional(ResourceLocation key, HolderLookup.Provider registryAccess) {
        return registryAccess.lookupOrThrow(ModRegistries.CLAY_MOB_TEAMS).get(ClayMobTeamManger.create(key)).map(Holder::value);
    }

    public static Optional<Holder.Reference<ClayMobTeam>> getHolder(ResourceLocation key, HolderLookup.Provider registryAccess) {
        return registryAccess.lookupOrThrow(ModRegistries.CLAY_MOB_TEAMS).get(ResourceKey.create(ModRegistries.CLAY_MOB_TEAMS, (ResourceLocation)key));
    }

    public static boolean isValidTeam(ResourceLocation key, RegistryAccess access) {
        return access.lookupOrThrow(ModRegistries.CLAY_MOB_TEAMS).containsKey(key);
    }

    @NotNull
    public static ClayMobTeam getFromKeyOrError(@NotNull ResourceLocation key, HolderLookup.Provider access) {
        if (access == null || key == null) {
            return ERROR;
        }
        return access.lookup(ModRegistries.CLAY_MOB_TEAMS).map(r -> r.get(ResourceKey.create(ModRegistries.CLAY_MOB_TEAMS, (ResourceLocation)key)).map(Holder::value).orElse(ERROR)).orElse(ERROR);
    }

    public static ItemStack createStackForTeam(ResourceLocation id, HolderLookup.Provider registries) {
        ItemStack stack = ModItems.CLAY_SOLDIER.get().getDefaultInstance();
        ClaySoldierSpawnItem.setClayMobTeam(stack, id, registries);
        return stack;
    }

    @Nullable
    public static ResourceLocation getFromItem(Item item) {
        return FROM_ITEM_MAP.get(item);
    }

    public static void appendFromItemMap(@Nullable Item item, ResourceLocation location) {
        if (item == null) {
            return;
        }
        FROM_ITEM_MAP.put(item, location);
    }

    public static @UnmodifiableView Map<Item, ResourceLocation> getFromItemMap() {
        return Map.copyOf(FROM_ITEM_MAP);
    }

    private static ResourceKey<ClayMobTeam> create(ResourceLocation location) {
        return ResourceKey.create(ModRegistries.CLAY_MOB_TEAMS, (ResourceLocation)location);
    }

    public static void registerDefault(Registry<ClayMobTeam> registry) {
        Optional noTeam;
        boolean defaultType = false;
        boolean noTeamType = false;
        if (registry.get(DEFAULT_TYPE).isEmpty()) {
            Registry.register(registry, (ResourceLocation)DEFAULT_TYPE, (Object)DEFAULT);
            defaultType = true;
        }
        if ((noTeam = registry.get(NO_TEAM_TYPE)).isEmpty()) {
            Registry.register(registry, (ResourceLocation)NO_TEAM_TYPE, (Object)NO_TEAM);
            noTeamType = true;
        } else {
            if (!((ClayMobTeam)((Holder.Reference)noTeam.orElseThrow()).value()).isFriendlyFireAllowed()) {
                LOGGER.warn("Created {} without friendly-fire enabled, however it probably should be", (Object)NO_TEAM);
            }
            if (((ClayMobTeam)((Holder.Reference)noTeam.orElseThrow()).value()).canBeTamed()) {
                LOGGER.warn("Created {} without taming disabled, however it probably should be", (Object)NO_TEAM);
            }
        }
        if (noTeamType && defaultType) {
            LOGGER.info("Registered {} and {} as they were not present", (Object)DEFAULT_TYPE, (Object)NO_TEAM_TYPE);
        } else if (noTeamType || defaultType) {
            LOGGER.info("Registered {} as it was not present", (Object)(noTeamType ? NO_TEAM_TYPE : DEFAULT_TYPE));
        }
    }

    private record ClayMobTeamReference(Holder.Reference<ClayMobTeam> base) implements IClayMobTeamReference
    {
        @Override
        @NotNull
        public ClayMobTeam value() {
            return (ClayMobTeam)this.base.value();
        }

        @Override
        @NotNull
        public ResourceLocation key() {
            return this.base.key().location();
        }
    }

    private static class ErrorClayMobTeam
    extends ClayMobTeam {
        protected ErrorClayMobTeam() {
            super("Error", ColorHelper.color(0xFF5555), true, true, Items.AIR);
        }

        @Override
        public boolean canBeUsed(Player player) {
            return false;
        }
    }
}

