/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.team;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.networking.ClayTeamPlayerDataPayload;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.team.TeamPlayerData;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class TeamLoyaltyManger {
    private static final Logger LOGGER = ClaySoldiersCommon.LOGGER;
    public static final StreamCodec<RegistryFriendlyByteBuf, TeamPlayerData.PlayerData> PLAYER_DATA_STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, TeamPlayerData.PlayerData::getUUID, (StreamCodec)ComponentSerialization.STREAM_CODEC, TeamPlayerData.PlayerData::getLastDisplayName, TeamPlayerData.PlayerData::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, Pair<ResourceLocation, TeamPlayerData.PlayerData>> STREAM_CODEC_TEAM_PLAYER = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, Pair::getFirst, PLAYER_DATA_STREAM_CODEC, Pair::getSecond, Pair::of);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<Pair<ResourceLocation, TeamPlayerData.PlayerData>>> STREAM_CODEC_TEAM_PLAYER_DATA = STREAM_CODEC_TEAM_PLAYER.apply(ByteBufCodecs.list());

    public static TeamPlayerData getTeamPlayerData(ServerLevel level) {
        return ServerTeamPlayerData.getFromLevel(level);
    }

    public static TeamPlayerData getClientTeamPlayerData() {
        ClientTeamPlayerData instance = ClientTeamPlayerData.INSTANCE;
        if (instance == null) {
            LOGGER.error("ClientTeamPlayerData has not yet been instantiated. Setting it to Empty");
            ClientTeamPlayerData.setEmpty();
        }
        return instance;
    }

    @ApiStatus.Internal
    public static void createClientTeamPlayerData(List<Pair<ResourceLocation, TeamPlayerData.PlayerData>> data, boolean reload) {
        ClientTeamPlayerData.createInstance(data, reload);
    }

    @ApiStatus.Internal
    public static void updateClientTeamPlayerData(ResourceLocation teamId, TeamPlayerData.PlayerData player) {
        ClientTeamPlayerData.INSTANCE.update(teamId, player);
    }

    @ApiStatus.Internal
    public static void removeClientTeamPlayerData(ResourceLocation teamId) {
        ClientTeamPlayerData.INSTANCE.remove(teamId);
    }

    @ApiStatus.Internal
    public static List<Pair<ResourceLocation, TeamPlayerData.PlayerData>> getTeamData(ServerLevel serverLevel) {
        return ServerTeamPlayerData.getFromLevel(serverLevel).toData();
    }

    public static boolean setTeamPlayer(ServerLevel level, ResourceLocation team, @Nullable Player player) {
        ServerTeamPlayerData serverData = ServerTeamPlayerData.getFromLevel(level);
        if (player != null) {
            return serverData.putPlayer(team, player);
        }
        TeamPlayerData.PlayerData prev = serverData.teamPlayerMap.remove(team);
        if (prev != null) {
            ClaySoldiersCommon.NETWORK_MANGER.sendToAllPlayers(level, new ClayTeamPlayerDataPayload.Remove(team));
            return true;
        }
        return false;
    }

    private static class ServerTeamPlayerData
    extends SavedData
    implements TeamPlayerData {
        private static final Logger LOGGER = ClaySoldiersCommon.LOGGER;
        private static final String TAG_NAME = "teamPlayerMap";
        private final ServerLevel level;
        private final Map<ResourceLocation, TeamPlayerData.PlayerData> teamPlayerMap = new HashMap<ResourceLocation, TeamPlayerData.PlayerData>();
        private long timeStampLastChange = 0L;

        private ServerTeamPlayerData(ServerLevel level) {
            this.level = level;
        }

        public static ServerTeamPlayerData getFromLevel(ServerLevel level) {
            return (ServerTeamPlayerData)level.getServer().overworld().getDataStorage().computeIfAbsent(ServerTeamPlayerData.factory(level), "clayTeamLoyalty");
        }

        public List<Pair<ResourceLocation, TeamPlayerData.PlayerData>> toData() {
            return this.teamPlayerMap.entrySet().stream().map(e -> Pair.of((Object)((ResourceLocation)e.getKey()), (Object)((TeamPlayerData.PlayerData)e.getValue()))).toList();
        }

        private static SavedData.Factory<ServerTeamPlayerData> factory(ServerLevel pLevel) {
            return new SavedData.Factory(() -> new ServerTeamPlayerData(pLevel), (tag, provider) -> ServerTeamPlayerData.load(pLevel, tag), null);
        }

        private static ServerTeamPlayerData load(ServerLevel level, CompoundTag tag) {
            ServerTeamPlayerData teamPlayerData = new ServerTeamPlayerData(level);
            if (!tag.contains(TAG_NAME)) {
                return teamPlayerData;
            }
            CompoundTag mapTag = tag.getCompound(TAG_NAME).copy();
            LOGGER.debug("Started Loading TeamLoyaltyData");
            for (String teamId : mapTag.getAllKeys()) {
                ResourceLocation resTeamId = ResourceLocation.parse((String)teamId);
                Optional<ClayMobTeam> team = ClayMobTeamManger.getOptional(resTeamId, (HolderLookup.Provider)level.registryAccess());
                if (team.isEmpty()) {
                    LOGGER.error("{} Team does not exist anymore removing it from SavedData", (Object)teamId);
                    continue;
                }
                if (!team.orElseThrow().canBeTamed()) {
                    LOGGER.error("{} Team cannot be loyal to anyone removing it from SavedData", (Object)teamId);
                    continue;
                }
                ServerTeamPlayerData.loadPlayerData(mapTag.get(teamId), playerData -> teamPlayerData.teamPlayerMap.put(resTeamId, (TeamPlayerData.PlayerData)playerData));
            }
            LOGGER.debug("Finished Loading TeamLoyaltyData");
            return teamPlayerData;
        }

        public CompoundTag save(CompoundTag pTag, HolderLookup.Provider pRegistries) {
            if (!this.teamPlayerMap.isEmpty()) {
                CompoundTag mapTag = new CompoundTag();
                this.teamPlayerMap.forEach((? super K k, ? super V v) -> ServerTeamPlayerData.savePlayerData(mapTag, k.toString(), v));
                pTag.put(TAG_NAME, (Tag)mapTag);
            }
            return pTag;
        }

        @Override
        public TeamPlayerData.PlayerData getPlayerForTeam(ResourceLocation teamId) {
            return this.teamPlayerMap.get(teamId);
        }

        @Override
        public long lastChangeTime() {
            return this.timeStampLastChange;
        }

        @Override
        public boolean putPlayerIfAbsent(ResourceLocation teamId, Player player) {
            if (this.teamPlayerMap.containsKey(teamId)) {
                return false;
            }
            this.putPlayer(teamId, player);
            return true;
        }

        public boolean putPlayer(ResourceLocation teamId, Player player) {
            @Nullable TeamPlayerData.PlayerData data = this.teamPlayerMap.get(teamId);
            if (data != null && data.is(player)) {
                return false;
            }
            ResourceLocation toRemove = null;
            for (Map.Entry<ResourceLocation, TeamPlayerData.PlayerData> entry : this.teamPlayerMap.entrySet()) {
                if (!entry.getValue().getUUID().equals(player.getUUID())) continue;
                toRemove = entry.getKey();
                break;
            }
            this.teamPlayerMap.remove(toRemove);
            TeamPlayerData.PlayerData playerData = ServerTeamPlayerData.playerDataFromPlayer(player);
            this.teamPlayerMap.put(teamId, playerData);
            this.setDirty();
            this.timeStampLastChange = this.level.getGameTime();
            ClaySoldiersCommon.NETWORK_MANGER.sendToAllPlayers(this.level, new ClayTeamPlayerDataPayload.Single(teamId, playerData));
            return true;
        }

        @Override
        public void forEach(BiConsumer<ResourceLocation, TeamPlayerData.PlayerData> action) {
            this.teamPlayerMap.forEach(action);
        }

        @Override
        public void updatePlayerName(ResourceLocation teamId, Player player) {
            TeamPlayerData.PlayerData data = this.teamPlayerMap.get(teamId);
            if (data == null) {
                return;
            }
            if (!data.getLastDisplayName().equals((Object)player.getDisplayName())) {
                data.setLastKnowName(player.getDisplayName());
                ClaySoldiersCommon.NETWORK_MANGER.sendToAllPlayers(this.level, new ClayTeamPlayerDataPayload.Single(teamId, data));
            }
        }

        public String toString() {
            return "ServerTeamLoyalData{" + String.valueOf(this.teamPlayerMap) + "}";
        }

        public static TeamPlayerData.PlayerData playerDataFromPlayer(Player player) {
            return new TeamPlayerData.PlayerData(player.getUUID(), player.getDisplayName());
        }

        public static void loadPlayerData(Tag tag, Consumer<TeamPlayerData.PlayerData> thenDo) {
            PLAYER_DATA_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).ifSuccess(thenDo).ifError(e -> LOGGER.error("Error Loading TeamLoyalty: {}", (Object)e.message()));
        }

        public static void savePlayerData(CompoundTag tag, String key, TeamPlayerData.PlayerData data) {
            PLAYER_DATA_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)data).ifSuccess(t -> tag.put(key, t)).ifError(e -> LOGGER.error("Error Saving TeamLoyalty for [{}|{}]: {}", new Object[]{key, data.getLastDisplayName(), e.message()}));
        }
    }

    private static class ClientTeamPlayerData
    implements TeamPlayerData {
        private static ClientTeamPlayerData INSTANCE = null;
        private static boolean wasCalledBeforeCreation = false;
        private final Map<ResourceLocation, TeamPlayerData.PlayerData> teamPlayerMap;

        private ClientTeamPlayerData(List<Pair<ResourceLocation, TeamPlayerData.PlayerData>> data) {
            this.teamPlayerMap = new HashMap<ResourceLocation, TeamPlayerData.PlayerData>(data.size());
            data.forEach((? super T pair) -> this.teamPlayerMap.put((ResourceLocation)pair.getFirst(), (TeamPlayerData.PlayerData)pair.getSecond()));
        }

        public static void createInstance(List<Pair<ResourceLocation, TeamPlayerData.PlayerData>> data, boolean reload) {
            if (wasCalledBeforeCreation) {
                LOGGER.error("ClientTeamPlayerData was accessed before creation. Resetting it");
            }
            if (INSTANCE != null && !reload) {
                LOGGER.debug("ClientTeamPlayerData instantiated twice. Current: {} , new Data: {}", (Object)INSTANCE, data);
            }
            INSTANCE = new ClientTeamPlayerData(data);
        }

        private static void setEmpty() {
            INSTANCE = new ClientTeamPlayerData(List.of());
            wasCalledBeforeCreation = true;
        }

        public void update(ResourceLocation teamID, TeamPlayerData.PlayerData player) {
            ResourceLocation toRemove = null;
            for (Map.Entry<ResourceLocation, TeamPlayerData.PlayerData> entry : ClientTeamPlayerData.INSTANCE.teamPlayerMap.entrySet()) {
                if (!entry.getValue().equals(player)) continue;
                toRemove = entry.getKey();
                break;
            }
            this.teamPlayerMap.remove(toRemove);
            this.teamPlayerMap.put(teamID, player);
        }

        public void remove(ResourceLocation teamID) {
            this.teamPlayerMap.remove(teamID);
        }

        @Override
        public boolean putPlayerIfAbsent(ResourceLocation teamId, Player player) {
            throw new UnsupportedOperationException("ClayMobTeam cannot be modified from the Client");
        }

        @Override
        public TeamPlayerData.PlayerData getPlayerForTeam(ResourceLocation teamId) {
            return this.teamPlayerMap.get(teamId);
        }

        @Override
        public long lastChangeTime() {
            return -1L;
        }

        @Override
        public void forEach(BiConsumer<ResourceLocation, TeamPlayerData.PlayerData> action) {
            this.teamPlayerMap.forEach(action);
        }

        @Override
        public void updatePlayerName(ResourceLocation teamId, Player player) {
            throw new UnsupportedOperationException("ClayMobTeam cannot be modified from the Client");
        }

        public String toString() {
            return "ClientTeamLoyalData{" + String.valueOf(this.teamPlayerMap) + "}";
        }
    }
}

