/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.util;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;

public interface EffectHolder {
    public static final Codec<EffectHolder> CODEC = RecordCodecBuilder.create(in -> CodecUtils.addEffectAnd().apply((Applicative)in, EffectHolder::create));

    default public MobEffect effect() {
        return (MobEffect)this.effectHolder().value();
    }

    public int duration();

    public int amplifier();

    public Holder<MobEffect> effectHolder();

    default public String effectHolderToString() {
        return "Effect: " + this.effect().getDisplayName().getString() + " Amplifier: " + this.amplifier() + " Duration: " + this.duration();
    }

    public static <T extends EffectHolder> Codec<T> getCodec(Function<EffectHolder, T> creates) {
        return CODEC.xmap(creates, e -> e);
    }

    public static <T extends EffectHolder> Codec<T> getCodec(Function<EffectHolder, T> creates, String prefix) {
        Codec codec = RecordCodecBuilder.create(in -> CodecUtils.addEffectAnd(prefix).apply((Applicative)in, EffectHolder::create));
        return codec.xmap(creates, e -> e);
    }

    public static EffectHolder create(final Holder<MobEffect> effect, final int duration, final int amplifier) {
        return new EffectHolder(){

            @Override
            public Holder<MobEffect> effectHolder() {
                return effect;
            }

            @Override
            public MobEffect effect() {
                return (MobEffect)effect.value();
            }

            @Override
            public int duration() {
                return duration;
            }

            @Override
            public int amplifier() {
                return amplifier;
            }
        };
    }
}

