/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.util.codec;

import io.netty.buffer.ByteBuf;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.soldierproperties.SoldierProperty;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMap;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class SoldierPropertyMapStreamCodec
implements StreamCodec<RegistryFriendlyByteBuf, SoldierPropertyMap> {
    public SoldierPropertyMap decode(RegistryFriendlyByteBuf buffer) {
        int size = ByteBufCodecs.readCount((ByteBuf)buffer, (int)this.getMaxSize());
        SoldierPropertyMap map = new SoldierPropertyMap();
        for (int i = 0; i < size; ++i) {
            SoldierProperty property = SoldierPropertyMapStreamCodec.decodeSoldierProperty(buffer);
            map.addPropertyForce(property);
        }
        return map;
    }

    private static <T> SoldierProperty<T> decodeSoldierProperty(RegistryFriendlyByteBuf buffer) {
        SoldierPropertyType type = (SoldierPropertyType)SoldierPropertyTypes.STREAM_CODEC.decode((Object)buffer);
        Object value = type.streamDecode(buffer);
        return new SoldierProperty(type, value);
    }

    public void encode(RegistryFriendlyByteBuf pBuffer, SoldierPropertyMap map) {
        ByteBufCodecs.writeCount((ByteBuf)pBuffer, (int)map.size(), (int)this.getMaxSize());
        map.forEach(soldierProperty -> {
            SoldierPropertyTypes.STREAM_CODEC.encode((Object)pBuffer, soldierProperty.type());
            soldierProperty.streamEncode(pBuffer);
        });
    }

    private int getMaxSize() {
        int size = ModRegistries.SOLDIER_PROPERTY_TYPES_REGISTRY.size();
        return size == 0 ? Integer.MAX_VALUE : size;
    }
}

