/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers;

import net.bumblebee.claysoldiers.ClaySoldiersClient;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.block.ModBlockEntityWithoutLevelRenderer;
import net.bumblebee.claysoldiers.init.ModMenuTypes;
import net.bumblebee.claysoldiers.init.ModParticles;
import net.bumblebee.claysoldiers.integration.ExternalMods;
import net.bumblebee.claysoldiers.integration.accessories.ModAccessoryRenderers;
import net.bumblebee.claysoldiers.integration.curios.ModCuriosRenderers;
import net.bumblebee.claysoldiers.item.ClayBrushItem;
import net.bumblebee.claysoldiers.item.blueprint.BlueprintItem;
import net.bumblebee.claysoldiers.menu.escritoire.EscritoireScreen;
import net.bumblebee.claysoldiers.menu.horse.ClayHorseScreen;
import net.bumblebee.claysoldiers.menu.soldier.ClaySoldierScreen;
import net.bumblebee.claysoldiers.particles.ScaledParticleProviderAdapter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.GlowParticle;
import net.minecraft.client.particle.HeartParticle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SuspendedTownParticle;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterEntitySpectatorShadersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@Mod(value="csr", dist={Dist.CLIENT})
public class ClaySoldiersNeoForgeClient {
    public ClaySoldiersNeoForgeClient(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        modEventBus.addListener(this::clientSetUp);
        modEventBus.addListener(this::registerClientExtensions);
        modEventBus.addListener(this::registerClientTooltipComponent);
        modEventBus.addListener(this::registerEntityInsideShader);
        modEventBus.addListener(this::registerParticles);
        modEventBus.addListener(this::registerMenuScreen);
        modEventBus.addListener(this::registerItemColorHandler);
        modEventBus.addListener(this::registerRenderers);
        modEventBus.addListener(this::registerModalLayers);
        modEventBus.addListener(this::registerResourceReloadListeners);
        NeoForge.EVENT_BUS.addListener(this::itemTooltipEvent);
    }

    private void clientSetUp(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ClayBrushItem.registerProperties(ItemProperties::register);
            BlueprintItem.registerProperties(ItemProperties::register);
            ExternalMods.ACCESSORIES.ifLoaded(() -> ModAccessoryRenderers::init);
            ExternalMods.CURIOS.ifLoaded(() -> ModCuriosRenderers::init);
            ClaySoldiersCommon.clientPlayer = () -> Minecraft.getInstance().player;
        });
    }

    private void itemTooltipEvent(ItemTooltipEvent event) {
        ClaySoldiersClient.tooltipEvent(event.getEntity(), event.getItemStack(), event.getToolTip());
    }

    private void registerClientTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
        ClaySoldiersClient.registerTooltipComponent((arg_0, arg_1) -> ((RegisterClientTooltipComponentFactoriesEvent)event).register(arg_0, arg_1));
    }

    private void registerClientExtensions(RegisterClientExtensionsEvent event) {
        IClientItemExtensions extension = new IClientItemExtensions(this){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ModBlockEntityWithoutLevelRenderer.getOrCreateInstance();
            }
        };
        ClaySoldiersClient.registerItemInHandRenderers(items -> event.registerItem(extension, (Item[])items.stream().map(ItemLike::asItem).toArray(Item[]::new)));
    }

    private void registerEntityInsideShader(RegisterEntitySpectatorShadersEvent event) {
        ClaySoldiersClient.registerEntityInsideShader((arg_0, arg_1) -> ((RegisterEntitySpectatorShadersEvent)event).register(arg_0, arg_1));
    }

    private void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticles.SMALL_HEART_PARTICLE.get(), pSprites -> new ScaledParticleProviderAdapter((ParticleProvider<SimpleParticleType>)new HeartParticle.Provider(pSprites), 0.35f));
        event.registerSpriteSet((ParticleType)ModParticles.SMALL_ANGRY_PARTICLE.get(), pSprites -> new ScaledParticleProviderAdapter((ParticleProvider<SimpleParticleType>)new HeartParticle.AngryVillagerProvider(pSprites), 0.35f));
        event.registerSpriteSet((ParticleType)ModParticles.SMALL_HAPPY_PARTICLE.get(), pSprites -> new ScaledParticleProviderAdapter((ParticleProvider<SimpleParticleType>)new SuspendedTownParticle.HappyVillagerProvider(pSprites), 1.1f));
        event.registerSpriteSet((ParticleType)ModParticles.SMALL_WAXED_PARTICLE.get(), pSprites -> new ScaledParticleProviderAdapter((ParticleProvider<SimpleParticleType>)new GlowParticle.WaxOnProvider(pSprites), 0.5f));
    }

    private void registerMenuScreen(RegisterMenuScreensEvent event) {
        event.register(ModMenuTypes.CLAY_SOLDIER_MENU.get(), ClaySoldierScreen::new);
        event.register(ModMenuTypes.CLAY_HORSE_MENU.get(), ClayHorseScreen::new);
        event.register(ModMenuTypes.ESCRITOIRE_MENU.get(), EscritoireScreen::new);
    }

    private void registerItemColorHandler(RegisterColorHandlersEvent.Item event) {
        ClaySoldiersClient.registerItemColorHandlers((x$0, xva$1) -> event.register(x$0, new ItemLike[]{xva$1}));
    }

    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ClaySoldiersClient.registerEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1));
        ClaySoldiersClient.registerBlockRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerBlockEntityRenderer(arg_0, arg_1));
    }

    private void registerModalLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        ClaySoldiersClient.registerModalLayers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
        ExternalMods.CURIOS.ifLoaded(() -> () -> ModCuriosRenderers.registerLayerEvent(event));
    }

    private void registerResourceReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)ClaySoldiersClient::reloadClayStaffModel));
    }
}

