/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers;

import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.block.hamsterwheel.BatteryProperty;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="csr")
public class ConfigNeoForge {
    private static final ModConfigSpec.Builder SERVER_BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.BooleanValue CLAY_SOLDIER_MENU_MODIFY = SERVER_BUILDER.comment("Whether the Inventory of a clay soldier can be edited via the menu. May cause loss of items.").define("claySoldierMenuModify", false);
    public static final ModConfigSpec.IntValue HAMSTER_WHEEL_CAPACITY = SERVER_BUILDER.comment("Capacity of the Hamster Wheel").defineInRange("hamsterWheelCapacity", 3000, 1, BatteryProperty.getMaxSupportedEnergy(i -> Integer.MAX_VALUE / i).intValue());
    public static final ModConfigSpec.IntValue HAMSTER_WHEEL_SPEED = SERVER_BUILDER.comment("Energy per Tick generated by the Hamster Wheel").defineInRange("hamsterWheelSpeed", 3, 1, Integer.MAX_VALUE);
    static final ModConfigSpec SPEC = SERVER_BUILDER.build();

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            ClaySoldiersCommon.claySolderMenuModify = (Boolean)CLAY_SOLDIER_MENU_MODIFY.get();
        }
    }

    @SubscribeEvent
    public static void onReLoad(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            ClaySoldiersCommon.claySolderMenuModify = (Boolean)CLAY_SOLDIER_MENU_MODIFY.get();
        }
    }
}

