/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.block.hamsterwheel;

import java.util.function.IntFunction;
import net.minecraft.util.StringRepresentable;

public enum BatteryProperty implements StringRepresentable
{
    NONE("none", 0),
    SINGLE("single", 1),
    DUAL("dual", 2);

    private final String serializedName;
    private final int capacityMultiplier;

    private BatteryProperty(String serializedName, int capacityMultiplier) {
        this.serializedName = serializedName;
        this.capacityMultiplier = capacityMultiplier;
    }

    public int getCapacityMultiplier() {
        return this.capacityMultiplier;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public static <T> T getMaxSupportedEnergy(IntFunction<T> maxMultiplierToStorage) {
        int maxMultiplier = 0;
        for (BatteryProperty batteryProperty : BatteryProperty.values()) {
            maxMultiplier = Math.max(batteryProperty.getCapacityMultiplier(), maxMultiplier);
        }
        return maxMultiplierToStorage.apply(maxMultiplier);
    }
}

