/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.block.hamsterwheel;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Consumer;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlock;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelModel;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelSoldierData;
import net.bumblebee.claysoldiers.block.hamsterwheel.IHamsterWheelEnergyStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;

public class HamsterWheelBlockEntityRenderer
implements BlockEntityRenderer<HamsterWheelBlockEntity> {
    private static final ResourceLocation HAMSTER_WHEEL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"textures/block/hamster_wheel.png");
    private static final ResourceLocation BATTERY_CONTENT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/water_still");
    private static final RenderType RENDER_TYPE_BLOCK = RenderType.entityCutoutNoCull((ResourceLocation)HAMSTER_WHEEL_TEXTURE);
    private static final float DEG_90 = 1.5707964f;
    private static final float WHEEL_SPEED = 0.1759292f;
    public static final ModelLayerLocation STAND_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"hamster_stand"), "main");
    public static final ModelLayerLocation POWER_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"hamster_power"), "main");
    private final ModelPart stand;
    private final ModelPart powerConnection;
    private final ModelPart batteryLeft;
    private final ModelPart batteryRight;
    private final HamsterWheelModel wheelModel;

    public HamsterWheelBlockEntityRenderer(BlockEntityRendererProvider.Context pContext) {
        this.stand = pContext.bakeLayer(STAND_LAYER_LOCATION);
        this.powerConnection = pContext.bakeLayer(POWER_LAYER_LOCATION);
        this.wheelModel = new HamsterWheelModel(pContext.bakeLayer(HamsterWheelModel.LAYER_LOCATION));
        this.batteryLeft = pContext.bakeLayer(BatteryType.LEFT.getLayerLocation());
        this.batteryRight = pContext.bakeLayer(BatteryType.RIGHT.getLayerLocation());
    }

    public void render(HamsterWheelBlockEntity hamsterWheelBlock, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        HamsterWheelSoldierData data;
        OptionalProfiler optProfiler = new OptionalProfiler(hamsterWheelBlock.getLevel());
        optProfiler.push("hamsterWheelRender");
        float yRot = ((Direction)hamsterWheelBlock.getBlockState().getValue((Property)HamsterWheelBlock.FACING)).getOpposite().toYRot();
        pPoseStack.translate(0.5f, 0.5f, 0.5f);
        pPoseStack.mulPose(Axis.YP.rotationDegrees(-yRot));
        pPoseStack.translate(-0.5f, -0.5f, -0.5f);
        VertexConsumer wheelBuilder = pBuffer.getBuffer(RENDER_TYPE_BLOCK);
        hamsterWheelBlock.clientTick(pPartialTick);
        this.stand.render(pPoseStack, wheelBuilder, pPackedLight, pPackedOverlay, -1);
        this.wheelModel.setUpRotation(hamsterWheelBlock.getRotationTick(pPartialTick) % 251.0f * 0.1759292f);
        this.wheelModel.renderToBuffer(pPoseStack, wheelBuilder, pPackedLight, pPackedOverlay, -1);
        if (hamsterWheelBlock.hasEnergyStorage()) {
            optProfiler.push("batteryRender");
            this.powerConnection.render(pPoseStack, wheelBuilder, pPackedLight, pPackedOverlay, -1);
            this.batteryLeft.render(pPoseStack, pBuffer.getBuffer(RENDER_TYPE_BLOCK), pPackedLight, pPackedOverlay, -1);
            HamsterWheelBlockEntityRenderer.renderBatterContent(hamsterWheelBlock, pBuffer, pPoseStack, pPackedLight);
            if (hamsterWheelBlock.hasSecondBattery()) {
                this.batteryRight.render(pPoseStack, pBuffer.getBuffer(RENDER_TYPE_BLOCK), pPackedLight, pPackedOverlay, -1);
                pPoseStack.pushPose();
                pPoseStack.translate(0.5625f, 0.0f, 0.0f);
                HamsterWheelBlockEntityRenderer.renderBatterContent(hamsterWheelBlock, pBuffer, pPoseStack, pPackedLight);
                pPoseStack.popPose();
            }
            optProfiler.pop();
        }
        if ((data = hamsterWheelBlock.getSoldierData()) != null) {
            optProfiler.push("soldierRender");
            pPoseStack.translate(0.5f, 0.1f, 0.5f);
            pPoseStack.mulPose(Axis.YP.rotation(1.5707964f));
            data.getClientSoldier().render(0.0f, pPartialTick, pPoseStack, pBuffer, pPackedLight);
            optProfiler.pop();
        }
        optProfiler.pop();
    }

    private static void renderBatterContent(HamsterWheelBlockEntity entity, MultiBufferSource buffer, PoseStack pPoseStack, int pPackedLight) {
        IHamsterWheelEnergyStorage energy = entity.getEnergyStorage(null);
        if (energy == null || energy.energyStored() == 0L) {
            return;
        }
        float height = Math.max(0.1f, 6.0f * (float)energy.energyStored() / (float)energy.maxEnergyStored());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(BATTERY_CONTENT_TEXTURE);
        VertexConsumer builder = buffer.getBuffer(Minecraft.useShaderTransparency() ? RenderType.solid() : RenderType.translucent());
        float textureScale = height / 6.0f;
        float u0 = sprite.getU0();
        float u1 = sprite.getU1();
        float v0 = sprite.getV0();
        float v1 = sprite.getV1();
        u1 = (u1 - u0) * 0.5f + u0;
        if (height <= 5.0f) {
            HamsterWheelBlockEntityRenderer.drawQuad(builder, pPoseStack, 2, height, 12, 5, height, 15, u0, v0, u1, (v1 - v0) * 0.5f + v0, pPackedLight);
        }
        if (height <= 1.0f) {
            return;
        }
        v1 = (v1 - v0) * textureScale + v0;
        HamsterWheelBlockEntityRenderer.drawQuad(builder, pPoseStack, 2, 0.0f, 12, 5, height, 12, u0, v0, u1, v1, pPackedLight);
        pPoseStack.pushPose();
        pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        pPoseStack.translate(-0.4375f, 0.0f, -1.875f);
        HamsterWheelBlockEntityRenderer.drawQuad(builder, pPoseStack, 2, 0.0f, 15, 5, height, 15, u0, v0, u1, v1, pPackedLight);
        pPoseStack.popPose();
        pPoseStack.pushPose();
        pPoseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        pPoseStack.translate(-1.6875f, 0.0f, 0.0f);
        HamsterWheelBlockEntityRenderer.drawQuad(builder, pPoseStack, 12, 0.0f, 2, 15, height, 2, u0, v0, u1, v1, pPackedLight);
        pPoseStack.popPose();
        pPoseStack.pushPose();
        pPoseStack.mulPose(Axis.YN.rotationDegrees(90.0f));
        pPoseStack.translate(0.0f, 0.0f, -0.625f);
        HamsterWheelBlockEntityRenderer.drawQuad(builder, pPoseStack, 12, 0.0f, 5, 15, height, 5, u0, v0, u1, v1, pPackedLight);
        pPoseStack.popPose();
    }

    private static void drawQuad(VertexConsumer builder, PoseStack poseStack, int x0, float y0, int z0, int x1, float y1, int z1, float u0, float v0, float u1, float v1, int packedLight) {
        HamsterWheelBlockEntityRenderer.drawVertex(builder, poseStack, (float)x0 / 16.0f, y0 / 16.0f, (float)z0 / 16.0f, u0, v0, 0.0f, 1.0f, 0.0f, packedLight);
        HamsterWheelBlockEntityRenderer.drawVertex(builder, poseStack, (float)x0 / 16.0f, y1 / 16.0f, (float)z1 / 16.0f, u0, v1, 0.0f, 1.0f, 0.0f, packedLight);
        HamsterWheelBlockEntityRenderer.drawVertex(builder, poseStack, (float)x1 / 16.0f, y1 / 16.0f, (float)z1 / 16.0f, u1, v1, 0.0f, 1.0f, 0.0f, packedLight);
        HamsterWheelBlockEntityRenderer.drawVertex(builder, poseStack, (float)x1 / 16.0f, y0 / 16.0f, (float)z0 / 16.0f, u1, v0, 0.0f, 1.0f, 0.0f, packedLight);
    }

    private static void drawVertex(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, float n0, float n1, float n2, int packedLight) {
        builder.addVertex(poseStack.last().pose(), x, y, z).setColor(-146800668).setUv(u, v).setLight(packedLight).setNormal(n0, n1, n2);
    }

    public static LayerDefinition createStandLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition stand = partdefinition.addOrReplaceChild("stand", CubeListBuilder.create().texOffs(14, 15).addBox(-1.0f, -3.1715f, 0.5f, 2.0f, 9.0f, 2.0f).texOffs(0, 0).addBox(-2.0f, 5.3285f, -3.501f, 4.0f, 1.0f, 7.0f), PartPose.offsetAndRotation((float)8.0f, (float)6.1715f, (float)11.5f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static LayerDefinition createPowerLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("power_connection", CubeListBuilder.create().texOffs(0, 8).addBox(-4.0f, -12.0f, 7.999f, 8.0f, 8.0f, 0.0f).texOffs(16, 8).addBox(-3.0f, -11.0f, 6.997f, 6.0f, 6.0f, 1.0f).texOffs(6, 21).addBox(0.5f, -6.0f, 6.998f, 1.0f, 6.0f, 1.0f).texOffs(0, 0).addBox(-1.5f, -6.0f, 6.998f, 1.0f, 6.0f, 1.0f).texOffs(24, 15).addBox(-0.75f, -8.535f, 6.0f, 1.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)8.0f, (float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    private static LayerDefinition createBatteryBase(BatteryType type) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(type.name, CubeListBuilder.create().texOffs(20, 23).addBox(-2.0f, -6.01f, -1.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.01f)).texOffs(8, 30).addBox(-1.0f, -6.5f, 0.0f, 1.0f, 1.0f, 1.0f).texOffs(4, 30).addBox(-3.011f, -0.75f, -0.75f, 1.0f, 1.0f, 1.0f).texOffs(0, 30).addBox(-3.011f, -0.75f, 0.75f, 1.0f, 1.0f, 1.0f), type.offsetAndRot);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static enum BatteryType {
        LEFT("battery_left", PartPose.offsetAndRotation((float)3.0f, (float)0.001f, (float)13.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI))),
        RIGHT("battery_right", PartPose.offsetAndRotation((float)13.0f, (float)0.001f, (float)14.0f, (float)0.0f, (float)((float)Math.PI), (float)((float)Math.PI)));

        private final String name;
        private final PartPose offsetAndRot;
        private final ModelLayerLocation layerLocation;

        private BatteryType(String name, PartPose offsetAndRot) {
            this.name = name;
            this.offsetAndRot = offsetAndRot;
            this.layerLocation = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)(name + "_layer")), "main");
        }

        public ModelLayerLocation getLayerLocation() {
            return this.layerLocation;
        }

        public LayerDefinition createLayerDefinition() {
            return HamsterWheelBlockEntityRenderer.createBatteryBase(this);
        }
    }

    private static class OptionalProfiler {
        private static final Consumer<String> PUSH_EMPTY = s -> {};
        private static final Runnable POP_EMPTY = () -> {};
        private final Runnable pop;
        private final Consumer<String> push;

        public OptionalProfiler(Level level) {
            if (level == null) {
                this.pop = POP_EMPTY;
                this.push = PUSH_EMPTY;
            } else {
                ProfilerFiller profiler = level.getProfiler();
                this.push = arg_0 -> ((ProfilerFiller)profiler).push(arg_0);
                this.pop = () -> ((ProfilerFiller)profiler).pop();
            }
        }

        private void push(String name) {
            this.push.accept(name);
        }

        private void pop() {
            this.pop.run();
        }
    }
}

