/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.block.hamsterwheel;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.client.ClientClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackWithEffect;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.util.ErrorHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class HamsterWheelSoldierData {
    private static final Codec<EntityType<?>> ENTITY_TYPE_CODEC = BuiltInRegistries.ENTITY_TYPE.byNameCodec();
    private static final List<String> IGNORED_TAGS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "Health", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "OnGround", "PortalCooldown", "Pos", "Rotation", "SleepingX", "SleepingY", "SleepingZ", "id", "Passengers", "leash", "Sitting", "Fuse", "ignited", "ExplosionRadius", "PoiPos", "CarriedItem", "team_id");
    private static final List<String> CLIENT_NEEDED_TAGS = Arrays.asList("SoldierBackpackItems", "SoldierHandItems", "SoldierArmorItems", "OffsetColor", "SkinVariantId", "Waxed");
    private static final String ACTIVE_EFFECTS_TAG = "active_effects";
    private static final StreamCodec<RegistryFriendlyByteBuf, EntityType<?>> STREAM_CODEC_ENTITY_TYPE = ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE);
    public static final StreamCodec<RegistryFriendlyByteBuf, HamsterWheelSoldierData> STREAM_CODEC_CLIENT = new StreamCodec<RegistryFriendlyByteBuf, HamsterWheelSoldierData>(){

        public HamsterWheelSoldierData decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            return HamsterWheelSoldierData.createUnsafe((EntityType)STREAM_CODEC_ENTITY_TYPE.decode((Object)registryFriendlyByteBuf), (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)registryFriendlyByteBuf), (CompoundTag)ByteBufCodecs.COMPOUND_TAG.decode((Object)registryFriendlyByteBuf), ((Float)ByteBufCodecs.FLOAT.decode((Object)registryFriendlyByteBuf)).floatValue(), ((Float)ByteBufCodecs.FLOAT.decode((Object)registryFriendlyByteBuf)).floatValue(), (Long)ByteBufCodecs.VAR_LONG.decode((Object)registryFriendlyByteBuf), (HolderLookup.Provider)registryFriendlyByteBuf.registryAccess());
        }

        public void encode(RegistryFriendlyByteBuf o, HamsterWheelSoldierData hamsterWheelSoldierData) {
            STREAM_CODEC_ENTITY_TYPE.encode((Object)o, hamsterWheelSoldierData.type);
            ResourceLocation.STREAM_CODEC.encode((Object)o, (Object)hamsterWheelSoldierData.getTeamId());
            ByteBufCodecs.FLOAT.encode((Object)o, (Object)Float.valueOf(hamsterWheelSoldierData.soldierScale));
            ByteBufCodecs.FLOAT.encode((Object)o, (Object)Float.valueOf(hamsterWheelSoldierData.speed));
            ByteBufCodecs.VAR_LONG.encode((Object)o, (Object)hamsterWheelSoldierData.enterTime);
        }
    };
    public static final String CLIENT_TAG = "client";
    private static final String ENTITY_TYPE_TAG = "type";
    private static final String DATA_TAG = "SoldierData";
    private static final String SOLDIER_SIZE_TAG = "SoldierSize";
    private static final String SOLDIER_SPEED_TAG = "SoldierSpeed";
    private static final String SOLDIER_ENTER_TAG = "SoldierEnterTime";
    private final EntityType<? extends AbstractClaySoldierEntity> type;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final CompoundTag data;
    @NotNull
    private final Holder.Reference<ClayMobTeam> teamReference;
    private final float soldierScale;
    private final float speed;
    private final float roundedSpeed;
    private final long enterTime;
    @Nullable
    private ClientClaySoldierEntity clientSoldier;

    private HamsterWheelSoldierData(EntityType<? extends AbstractClaySoldierEntity> type, CompoundTag data, ResourceLocation teamId, float soldierScale, float speed, long enterTime, HolderLookup.Provider registries) {
        this.type = type;
        this.data = data;
        this.speed = speed;
        this.roundedSpeed = (float)Math.round((double)speed * 3.4 * 10.0) / 10.0f;
        this.soldierScale = soldierScale;
        this.enterTime = enterTime;
        this.teamReference = ClayMobTeamManger.getHolder(teamId, registries).orElse(ClayMobTeamManger.getDefault(registries));
    }

    public ResourceLocation getTeamId() {
        return this.teamReference.key().location();
    }

    private static HamsterWheelSoldierData createUnsafe(EntityType<?> type, ResourceLocation id, CompoundTag tag, float size, float speed, long enterTime, HolderLookup.Provider registries) {
        try {
            return new HamsterWheelSoldierData(type, tag, id, size, speed, enterTime, registries);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Type " + String.valueOf(type) + " does not extend AbstractClaySoldierEntity");
        }
    }

    public static HamsterWheelSoldierData of(AbstractClaySoldierEntity soldier) {
        CompoundTag compoundtag = new CompoundTag();
        soldier.save(compoundtag);
        IGNORED_TAGS.forEach(arg_0 -> ((CompoundTag)compoundtag).remove(arg_0));
        return HamsterWheelSoldierData.createUnsafe(soldier.getType(), soldier.getClayTeamType(), compoundtag, soldier.getScale(), (float)soldier.getAttribute(Attributes.MOVEMENT_SPEED).getValue(), soldier.level().getGameTime(), (HolderLookup.Provider)soldier.registryAccess());
    }

    public void save(CompoundTag tag) {
        ENTITY_TYPE_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.type).ifSuccess(typeTag -> tag.put(ENTITY_TYPE_TAG, typeTag)).ifError(err -> LOGGER.error(err.message()));
        ClayMobTeam.save(this.getTeamId(), tag);
        if (tag.contains(CLIENT_TAG)) {
            tag.put(DATA_TAG, (Tag)this.getForClient());
        } else {
            tag.put(DATA_TAG, (Tag)this.getForServer());
            tag.putLong(SOLDIER_ENTER_TAG, this.enterTime);
        }
        if (this.soldierScale != 1.0f) {
            tag.putFloat(SOLDIER_SIZE_TAG, this.soldierScale);
        }
        if (this.speed >= 0.31f || this.speed <= 0.29f) {
            tag.putFloat(SOLDIER_SPEED_TAG, this.speed);
        }
    }

    @Nullable
    public static HamsterWheelSoldierData load(CompoundTag tag, BlockPos pos, WalkAnimationState state, HolderLookup.Provider registries) {
        if (!tag.contains(ENTITY_TYPE_TAG)) {
            return null;
        }
        EntityType type = (EntityType)ENTITY_TYPE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(ENTITY_TYPE_TAG)).getOrThrow(err -> new IllegalStateException("Cannot load SoldierBlockData without EntityType: " + err));
        ResourceLocation id = ClayMobTeam.read(tag);
        CompoundTag data = tag.getCompound(DATA_TAG);
        float size = 1.0f;
        if (tag.contains(SOLDIER_SIZE_TAG, 99)) {
            size = tag.getFloat(SOLDIER_SIZE_TAG);
        }
        float speed = 0.3f;
        if (tag.contains(SOLDIER_SPEED_TAG, 99)) {
            speed = tag.getFloat(SOLDIER_SPEED_TAG);
        }
        HamsterWheelSoldierData blockData = HamsterWheelSoldierData.createUnsafe(type, id, data, size, speed, tag.getLong(SOLDIER_ENTER_TAG), registries);
        if (tag.contains(CLIENT_TAG)) {
            blockData.setUpClient(pos, state);
        }
        return blockData;
    }

    public static void markTagAsClient(CompoundTag tag) {
        tag.putBoolean(CLIENT_TAG, true);
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAdjustedSpeed() {
        return this.roundedSpeed;
    }

    public AbstractClaySoldierEntity createSoldier(Level level) {
        CompoundTag newEntityData = this.data.copy();
        IGNORED_TAGS.forEach(arg_0 -> ((CompoundTag)newEntityData).remove(arg_0));
        AbstractClaySoldierEntity entity = (AbstractClaySoldierEntity)this.type.create(level);
        ClayMobTeam.save(this.getTeamId(), newEntityData);
        if (entity != null) {
            CustomData.of((CompoundTag)newEntityData).loadInto((Entity)entity);
            if (this.data.hasUUID("UUID")) {
                entity.setUUID(this.data.getUUID("UUID"));
            } else {
                ErrorHandler.INSTANCE.debug("Loaded a ClaySoldier without its UUID");
            }
            entity.getActiveEffectsMap().clear();
            entity.getActiveEffectsMap().putAll(HamsterWheelSoldierData.loadEffects(this.data, (int)(level.getGameTime() - this.enterTime)));
            return entity;
        }
        return null;
    }

    private static Map<Holder<MobEffect>, MobEffectInstance> loadEffects(CompoundTag tag, int elapsedTime) {
        HashMap<Holder<MobEffect>, MobEffectInstance> map = new HashMap<Holder<MobEffect>, MobEffectInstance>();
        if (tag.contains(ACTIVE_EFFECTS_TAG, 9)) {
            ListTag listtag = tag.getList(ACTIVE_EFFECTS_TAG, 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.getCompound(i);
                MobEffectInstance oldEff = MobEffectInstance.load((CompoundTag)compoundtag);
                if (oldEff == null || oldEff.endsWithin(elapsedTime)) continue;
                MobEffectInstance newInstance = new MobEffectInstance(oldEff.getEffect(), Math.max(1, oldEff.getDuration() - elapsedTime), oldEff.getAmplifier(), oldEff.isAmbient(), oldEff.isVisible(), oldEff.showIcon());
                map.put((Holder<MobEffect>)oldEff.getEffect(), newInstance);
            }
        }
        return map;
    }

    @Nullable
    public ClientClaySoldierEntity getClientSoldier() {
        return this.clientSoldier;
    }

    private CompoundTag getForClient() {
        CompoundTag tag = new CompoundTag();
        ArrayList missingTags = new ArrayList();
        CLIENT_NEEDED_TAGS.forEach(tagKey -> {
            Tag entry = this.data.get(tagKey);
            if (entry != null) {
                tag.put(tagKey, entry);
            } else {
                missingTags.add(tagKey);
            }
        });
        if (!missingTags.isEmpty()) {
            LOGGER.debug("Missing Client Tags: {}", missingTags);
        }
        ClayMobTeam.save(this.getTeamId(), tag);
        return tag;
    }

    private CompoundTag getForServer() {
        CompoundTag tag = this.data.copy();
        ClayMobTeam.save(this.getTeamId(), tag);
        return tag;
    }

    private void setUpClient(BlockPos pos, WalkAnimationState state) {
        this.clientSoldier = ClientClaySoldierEntity.create(this.type, this.data, pos, state, this.teamReference, this.soldierScale);
        this.clientSoldier.setUpCape();
    }

    public void dropItems(ServerLevel level, double x, double y, double z) {
        ArrayList stackWithEffects = new ArrayList();
        AbstractClaySoldierEntity.getFromTag(this.data, "SoldierHandItems", (i, s) -> stackWithEffects.add(s), level.registryAccess());
        AbstractClaySoldierEntity.getFromTag(this.data, "SoldierArmorItems", (i, s) -> stackWithEffects.add(s), level.registryAccess());
        AbstractClaySoldierEntity.getFromTag(this.data, "SoldierBackpackItems", (i, s) -> stackWithEffects.add(s), level.registryAccess());
        AbstractClaySoldierEntity.dropInventory(level, slot -> (ItemStackWithEffect)stackWithEffects.get(slot.ordinal()), (slot, stack) -> HamsterWheelSoldierData.spawnItemInWorld(level, stack, x, y, z));
        if (this.data.contains("DropSpawnedFrom") && this.data.getBoolean("DropSpawnedFrom")) {
            ClayMobEntity.dropSpawnedFrom(level, ClayMobEntity.getSpawnedFromFromTag(this.data, level.registryAccess()), stack -> HamsterWheelSoldierData.spawnItemInWorld(level, stack, x, y, z), false, false);
        }
    }

    private static void spawnItemInWorld(ServerLevel level, ItemStack stack, double x, double y, double z) {
        ItemEntity itemEntity = new ItemEntity((Level)level, x, y, z, stack);
        itemEntity.setDefaultPickUpDelay();
        level.addFreshEntity((Entity)itemEntity);
    }

    public String toString() {
        return "HamsterWheelSoldierData(%s(%s))".formatted(this.type.getBaseClass().getSimpleName(), this.getTeamId());
    }
}

