/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.bumblebee.claysoldiers.blueprint.BlueprintData;
import net.bumblebee.claysoldiers.blueprint.templates.BaseImmutableTemplate;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintUtil;
import net.bumblebee.claysoldiers.blueprint.templates.ImmutableTemplate;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.item.blueprint.BlueprintItem;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

public class BlueprintManger
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String BLUEPRINT_FILE_PATH = "%s/blueprint".formatted("csr");
    private static final Logger LOGGER = LogUtils.getLogger();
    private final HolderLookup<Block> blockLookup;
    private final HolderLookup<BlueprintData> blueprintHolders;
    private final BiConsumer<BlueprintManger, ResourceManager> tagLoader;

    public BlueprintManger(HolderLookup<Block> blockLookup, HolderLookup<BlueprintData> blueprintRegistry, BiConsumer<BlueprintManger, ResourceManager> tagLoader) {
        super(GSON, BLUEPRINT_FILE_PATH);
        this.blockLookup = blockLookup;
        this.blueprintHolders = blueprintRegistry;
        this.tagLoader = tagLoader;
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonElementMap, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.tagLoader.accept(this, pResourceManager);
        LOGGER.info("Clay Soldiers: Done Loading {} Blueprints", this.blueprintHolders.listElements().map(Holder::value).toList());
    }

    public void onTagLoad(ResourceManager pResourceManager, Collection<Holder<Block>> blackListedBlocks) {
        Function<ResourceLocation, Optional<ImmutableTemplate>> helper = BlueprintUtil.createBlueprintLoader(pResourceManager, this.blockLookup, blackListedBlocks);
        this.blueprintHolders.listElements().map(Holder.Reference::value).forEach(data -> ((Optional)helper.apply(data.location())).ifPresentOrElse(data::bindStructure, () -> LOGGER.error("Clay Soldiers: Couldn't load structure {} for Blueprint", (Object)data.location())));
    }

    public static List<ItemStack> getBlueprintItems(HolderLookup.Provider provider) {
        return provider.lookupOrThrow(ModRegistries.BLUEPRINTS).listElements().filter(h -> ((BlueprintData)h.value()).isValid()).map(BlueprintItem::createStackFromData).toList();
    }

    public static ItemStack createBlueprintItem(BlueprintData data, RegistryAccess registryAccess) {
        return BlueprintItem.createStackFromData((Holder<BlueprintData>)registryAccess.registryOrThrow(ModRegistries.BLUEPRINTS).wrapAsHolder((Object)data));
    }

    @ApiStatus.Internal
    public static void setupClient(Map<ResourceLocation, BaseImmutableTemplate> blueprintShapes, RegistryAccess access) {
        Registry reg = access.registryOrThrow(ModRegistries.BLUEPRINTS);
        reg.holders().forEach(holder -> ((BlueprintData)holder.value()).bindStructure((BaseImmutableTemplate)blueprintShapes.get(holder.key().location())));
        reg.holders().forEach(data -> {
            if (!((BlueprintData)data.value()).isValid()) {
                LOGGER.error("Clay Soldiers: Loaded Invalid Blueprint Data on the Client {}", data);
            }
        });
        LOGGER.info("Clay Soldiers: Done Loading {} Blueprints on Client", reg.stream().toList());
    }

    @ApiStatus.Internal
    public static Map<ResourceLocation, BaseImmutableTemplate> getBlueprintShapeData(RegistryAccess registryAccess) {
        HashMap<ResourceLocation, BaseImmutableTemplate> map = new HashMap<ResourceLocation, BaseImmutableTemplate>();
        registryAccess.registryOrThrow(ModRegistries.BLUEPRINTS).holders().filter(h -> ((BlueprintData)h.value()).isValid()).forEach(h -> map.put(h.key().location(), ((BlueprintData)h.value()).getTemplate()));
        return map;
    }
}

