/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint.templates;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.blueprint.BlueprintTemplateSettings;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class BlueprintPlan {
    public static final String ITEMS_TAG = "ItemMap";
    public static final String HAS_STARTED_TAG = "Started";
    protected static final Codec<Map<Item, Integer>> ITEM_COUNT_MAP_CODEC = Codec.unboundedMap((Codec)BuiltInRegistries.ITEM.byNameCodec(), (Codec)Codec.INT);
    private boolean hasStarted;
    private final Map<Item, Integer> itemCountMap;
    private final Vec3i size;

    public BlueprintPlan(Map<Item, Integer> itemCountMap, Vec3i size) {
        this.itemCountMap = itemCountMap;
        this.size = size;
        this.hasStarted = false;
    }

    public abstract PlaceResult tryPlacing(Level var1, ItemStack var2, BlockPos var3, BlueprintTemplateSettings var4);

    public boolean hasItemAndShrink(Item item) {
        if (!this.itemCountMap.containsKey(item)) {
            return false;
        }
        Integer count = this.itemCountMap.get(item);
        if (count == null || count <= 0) {
            return false;
        }
        Integer n = count;
        count = count - 1;
        if (count <= 0) {
            this.itemCountMap.remove(item);
        } else {
            this.itemCountMap.put(item, count);
        }
        return true;
    }

    protected int getNumberOfItems() {
        return this.itemCountMap.values().stream().reduce(0, Integer::sum);
    }

    public List<ItemStack> getNeededItems() {
        return BlueprintUtil.itemMapToList(this.itemCountMap);
    }

    public boolean isFinished() {
        return this.itemCountMap.isEmpty();
    }

    public Vec3i getSize() {
        return this.size;
    }

    public boolean hasStarted() {
        return this.hasStarted;
    }

    public void saveHasStarted(CompoundTag tag) {
        if (this.hasStarted()) {
            tag.putBoolean(HAS_STARTED_TAG, true);
        }
    }

    public void saveSize(CompoundTag tag) {
        tag.put("size", (Tag)this.newIntegerList(this.getSize().getX(), this.getSize().getY(), this.getSize().getZ()));
    }

    public void saveItems(CompoundTag tag) {
        if (this.itemCountMap.isEmpty()) {
            return;
        }
        ITEM_COUNT_MAP_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.itemCountMap).ifSuccess(itemCountTag -> tag.put(ITEMS_TAG, itemCountTag)).ifError(tagError -> ClaySoldiersCommon.LOGGER.error(tagError.message()));
    }

    protected void loadItemCount(CompoundTag tag) {
        if (tag.contains(ITEMS_TAG)) {
            ITEM_COUNT_MAP_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(ITEMS_TAG)).ifSuccess(this.itemCountMap::putAll).ifError(mapError -> BlueprintUtil.LOGGER.error(mapError.message()));
        }
    }

    protected void loadHasStarted(CompoundTag tag) {
        this.hasStarted = tag.contains(HAS_STARTED_TAG) && tag.getBoolean(HAS_STARTED_TAG);
    }

    protected ListTag newIntegerList(int ... pValues) {
        ListTag listtag = new ListTag();
        for (int i : pValues) {
            listtag.add((Object)IntTag.valueOf((int)i));
        }
        return listtag;
    }

    public static enum PlaceResult {
        SUCCESS,
        NOT_NEEDED,
        CANT_PLACE;


        public boolean isSuccess() {
            return this == SUCCESS;
        }

        public boolean isFail() {
            return this != SUCCESS;
        }
    }
}

