/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint.templates;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.bumblebee.claysoldiers.blueprint.BlueprintRequest;
import net.bumblebee.claysoldiers.blueprint.BlueprintTemplateSettings;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintBlockInfo;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintPlan;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintUtil;
import net.bumblebee.claysoldiers.blueprint.templates.ImmutableTemplate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class ServerBlueprintPlan
extends BlueprintPlan {
    private final List<BlueprintBlockInfo> blockInfoList;

    public ServerBlueprintPlan(Vec3i size, List<StructureTemplate.StructureBlockInfo> blockInfoList) {
        super(BlueprintUtil.getNeededItemsFromInfo(blockInfoList, StructureTemplate.StructureBlockInfo::state), size);
        this.blockInfoList = ServerBlueprintPlan.fromBlockInfoList(blockInfoList);
    }

    public static ServerBlueprintPlan load(CompoundTag tag, HolderLookup.Provider registries) {
        ServerBlueprintPlan serverBlueprintPlan = new ServerBlueprintPlan(BlueprintUtil.getSizeFromTag(tag), ImmutableTemplate.loadPallet((HolderLookup<Block>)registries.lookupOrThrow(Registries.BLOCK), tag.getList("palette", 10), tag.getList("blocks", 10), List.of()));
        serverBlueprintPlan.loadHasStarted(tag);
        return serverBlueprintPlan;
    }

    public CompoundTag save(CompoundTag pTag) {
        if (this.blockInfoList.isEmpty()) {
            pTag.put("blocks", (Tag)new ListTag());
            pTag.put("palette", (Tag)new ListTag());
        } else {
            BlueprintUtil.SimplePalette simplePalette = new BlueprintUtil.SimplePalette();
            ListTag blockInfoAsPallet = new ListTag();
            this.blockInfoList.forEach(blockInfo -> {
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.put("pos", (Tag)this.newIntegerList(blockInfo.getPos().getX(), blockInfo.getPos().getY(), blockInfo.getPos().getZ()));
                int stateId = simplePalette.idFor(blockInfo.getState());
                compoundtag.putInt("state", stateId);
                if (blockInfo.getNbt() != null) {
                    compoundtag.put("nbt", (Tag)blockInfo.getNbt());
                }
                blockInfoAsPallet.add((Object)compoundtag);
            });
            pTag.put("blocks", (Tag)blockInfoAsPallet);
            ListTag palletTag = new ListTag();
            for (BlockState blockstate : simplePalette) {
                palletTag.add((Object)NbtUtils.writeBlockState((BlockState)blockstate));
            }
            pTag.put("palette", (Tag)palletTag);
        }
        this.saveSize(pTag);
        this.saveHasStarted(pTag);
        return pTag;
    }

    @Override
    public BlueprintPlan.PlaceResult tryPlacing(Level level, ItemStack itemStack, BlockPos base, BlueprintTemplateSettings settings) {
        BlueprintPlan.PlaceResult res = this.tryPlacingAll(((BlockItem)itemStack.getItem()).getBlock(), itemStack, level, base, settings);
        if (res == BlueprintPlan.PlaceResult.SUCCESS && !this.hasItemAndShrink(itemStack.getItem())) {
            throw new IllegalStateException("Successfully placed a Block which was not needed");
        }
        return res;
    }

    private BlueprintPlan.PlaceResult tryPlacingAll(Block block, ItemStack stack, Level level, BlockPos base, BlueprintTemplateSettings settings) {
        Iterator<BlueprintBlockInfo> iterator = this.blockInfoList.iterator();
        while (iterator.hasNext()) {
            StructureTemplate.StructureBlockInfo updatedBlockInfo;
            BlueprintBlockInfo blockInfo = iterator.next();
            if (!blockInfo.isFor(block) || !this.placeBlock(stack, level, (updatedBlockInfo = ServerBlueprintPlan.processBlockInfos(settings, blockInfo)).pos().offset((Vec3i)base), updatedBlockInfo.state().mirror(settings.mirror()).rotate(settings.rotation()))) continue;
            iterator.remove();
            blockInfo.markDone();
            return BlueprintPlan.PlaceResult.SUCCESS;
        }
        return BlueprintPlan.PlaceResult.CANT_PLACE;
    }

    private boolean placeBlock(ItemStack stack, Level level, BlockPos pos, BlockState state) {
        if (!this.canPlaceBlock(level, pos)) {
            return false;
        }
        if (level.setBlock(pos, state, 3)) {
            state.getBlock().setPlacedBy(level, pos, state, null, stack);
            return true;
        }
        return false;
    }

    private boolean canPlaceBlock(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.isAir() || state.canBeReplaced();
    }

    private static StructureTemplate.StructureBlockInfo processBlockInfos(BlueprintTemplateSettings pSettings, BlueprintBlockInfo pBlockInfo) {
        return new StructureTemplate.StructureBlockInfo(ServerBlueprintPlan.adjustForStructureSettings(pSettings, pBlockInfo.getPos()), pBlockInfo.getState(), pBlockInfo.getNbt() != null ? pBlockInfo.getNbt().copy() : null);
    }

    public String toString() {
        return "ServerBlueprintTemplate{%s Blocks(%s) Items(%s): %s}".formatted(this.getSize(), this.blockInfoList.size(), this.getNumberOfItems(), this.getNeededItems());
    }

    @Nullable
    public BlueprintRequest getRequest(ServerLevel level, BlockPos base, BlueprintTemplateSettings settings, Predicate<BlockPos> canReach) {
        Supplier<BlueprintRequest> fallbackRequest = null;
        for (BlueprintBlockInfo blockInfo : this.blockInfoList) {
            BlockPos infoAbsolutePos = base.offset((Vec3i)ServerBlueprintPlan.adjustForStructureSettings(settings, blockInfo.getPos()));
            if (!canReach.test(infoAbsolutePos) || !this.canPlaceBlock((Level)level, infoAbsolutePos)) continue;
            if (blockInfo.hasAvailableRequest(level.getGameTime())) {
                return blockInfo.getRequest(level.getGameTime(), infoAbsolutePos);
            }
            if (fallbackRequest != null) continue;
            fallbackRequest = () -> blockInfo.getRequest(level.getGameTime(), infoAbsolutePos);
        }
        return fallbackRequest != null ? (BlueprintRequest)fallbackRequest.get() : null;
    }

    @Override
    public boolean isFinished() {
        return this.blockInfoList.isEmpty();
    }

    private static BlockPos adjustForStructureSettings(BlueprintTemplateSettings settings, BlockPos pos) {
        return StructureTemplate.calculateRelativePosition((StructurePlaceSettings)settings.convertTo(), (BlockPos)pos.offset((Vec3i)BlockPos.ZERO));
    }

    private static List<BlueprintBlockInfo> fromBlockInfoList(List<StructureTemplate.StructureBlockInfo> infoList) {
        return infoList.stream().map(BlueprintBlockInfo::fromInfo).collect(Collectors.toCollection(LinkedList::new));
    }
}

