/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.cap;

import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierInventoryHandler;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ClaySoldierItemHandler
implements IItemHandler {
    private final ClaySoldierInventoryHandler inventory;

    public ClaySoldierItemHandler(ClaySoldierInventoryHandler inventory) {
        this.inventory = inventory;
    }

    public int getSlots() {
        return SoldierEquipmentSlot.values().length;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory.getItemBySlot(this.validateSlotIndex(slot)).stack();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        SoldierEquipmentSlot equipmentSlot = this.validateSlotIndex(slot);
        ItemStack existing = this.inventory.getItemBySlot(equipmentSlot).stack();
        int limit = this.getSlotLimit(slot);
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                this.inventory.setItemSlot(equipmentSlot, reachedLimit ? stack.copyWithCount(limit) : stack);
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
        }
        return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        SoldierEquipmentSlot equipmentSlot = this.validateSlotIndex(slot);
        ItemStack existing = this.inventory.getItemBySlot(equipmentSlot).stack();
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                this.inventory.setItemSlot(equipmentSlot, ItemStack.EMPTY);
            }
            return existing;
        }
        if (!simulate) {
            this.inventory.setItemSlot(equipmentSlot, existing.copyWithCount(existing.getCount() - toExtract));
        }
        return existing.copyWithCount(toExtract);
    }

    public int getSlotLimit(int slot) {
        return this.inventory.getItemBySlot(this.validateSlotIndex(slot)).maxSoldierStackSize();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        SoldierHoldableEffect effect = ClaySoldiersCommon.DATA_MAP.getEffect(stack);
        if (effect == null) {
            return false;
        }
        return this.inventory.couldEquipStack(effect);
    }

    protected SoldierEquipmentSlot validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new IllegalArgumentException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
        return SoldierEquipmentSlot.values()[slot];
    }
}

