/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.cap;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.capability.IBlockCache;
import net.bumblebee.claysoldiers.capability.IBlockStorageAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.items.IItemHandler;

public class NeoForgeBlockStorageCapability
implements IBlockCache<IBlockStorageAccess> {
    private final BlockCapabilityCache<IItemHandler, Direction> cache;

    public NeoForgeBlockStorageCapability(BlockCapabilityCache<IItemHandler, Direction> cache) {
        this.cache = cache;
    }

    @Override
    public BlockPos pos() {
        return this.cache.pos();
    }

    @Override
    public IBlockStorageAccess getCapability() {
        IItemHandler itemHandler = (IItemHandler)this.cache.getCapability();
        return itemHandler == null ? null : new NeoForgeBlockStorageAccess(itemHandler);
    }

    public static class NeoForgeBlockStorageAccess
    implements IBlockStorageAccess {
        private final IItemHandler itemHandler;

        public NeoForgeBlockStorageAccess(IItemHandler iItemHandler) {
            this.itemHandler = iItemHandler;
        }

        @Override
        public ItemStack tryInserting(ItemStack stack) {
            ItemStack stackToInsert = stack.copy();
            for (int i = 0; i < this.itemHandler.getSlots() && !(stackToInsert = this.itemHandler.insertItem(i, stackToInsert, false)).isEmpty(); ++i) {
            }
            return stackToInsert;
        }

        @Override
        public ItemStack tryExtracting(Predicate<ItemStack> stackPredicate, int amount) {
            ItemStack stack = ItemStack.EMPTY;
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                if (!stackPredicate.test(this.itemHandler.getStackInSlot(i)) || (stack = this.itemHandler.extractItem(i, amount, false)).isEmpty()) continue;
                return stack;
            }
            return stack;
        }

        @Override
        public void forEach(ToIntFunction<ItemStack> test, Consumer<ItemStack> thenDo, BooleanSupplier finished) {
            for (int i = 0; i < this.itemHandler.getSlots() && !finished.getAsBoolean(); ++i) {
                ItemStack stack;
                int amountWanted = test.applyAsInt(this.itemHandler.getStackInSlot(i));
                if (amountWanted <= 0 || (stack = this.itemHandler.extractItem(i, amountWanted, false)).isEmpty()) continue;
                thenDo.accept(stack);
            }
        }
    }
}

