/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.capability;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierInventoryHandler;
import net.bumblebee.claysoldiers.init.ModItems;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public interface CustomEquipCapability {
    public static final BiFunction<ItemStack, SoldierHoldableEffect, CustomEquipCapability> SHEARS = (stack, effect) -> soldier -> {
        if (soldier.setSlotIfEmpty(SoldierEquipmentSlot.OFFHAND, ModItems.SHEAR_BLADE.get().getDefaultInstance()) && soldier.setSlotIfEmpty(SoldierEquipmentSlot.MAINHAND, ModItems.SHEAR_BLADE.get().getDefaultInstance())) {
            return stack;
        }
        return ItemStack.EMPTY;
    };
    public static final BiFunction<ItemStack, SoldierHoldableEffect, CustomEquipCapability> GOLD_BLOCK = (stack, effect) -> soldier -> CustomEquipCapability.royaltyEquip(stack, soldier, Items.GOLD_INGOT);
    public static final BiFunction<ItemStack, SoldierHoldableEffect, CustomEquipCapability> DIAMOND_BLOCK = (stack, effect) -> soldier -> CustomEquipCapability.royaltyEquip(stack, soldier, Items.DIAMOND);
    public static final BiFunction<ItemStack, SoldierHoldableEffect, CustomEquipCapability> IRON_NUGGET = (stack, effect) -> soldier -> {
        if (soldier.getItemBySlot(SoldierEquipmentSlot.OFFHAND).is(Items.BOWL)) {
            soldier.setItemSlot(SoldierEquipmentSlot.OFFHAND, (ItemStack)stack);
            return stack;
        }
        if (soldier.getItemBySlot(SoldierEquipmentSlot.MAINHAND).is(Items.BOWL)) {
            soldier.setItemSlot(SoldierEquipmentSlot.MAINHAND, (ItemStack)stack);
            return stack;
        }
        return ItemStack.EMPTY;
    };
    public static final Map<ItemLike, BiFunction<ItemStack, SoldierHoldableEffect, CustomEquipCapability>> CUSTOM_EQUIP_MAP = new HashMap<Item, BiFunction<ItemStack, SoldierHoldableEffect, CustomEquipCapability>>(Map.of(Items.SHEARS, SHEARS, Items.GOLD_BLOCK, GOLD_BLOCK, Items.DIAMOND_BLOCK, DIAMOND_BLOCK, Items.IRON_NUGGET, IRON_NUGGET));

    public ItemStack equip(ClaySoldierInventoryHandler var1);

    public static ItemStack royaltyEquip(ItemStack stack, ClaySoldierInventoryHandler inventory, Item toReplace) {
        if (inventory.getItemBySlot(SoldierEquipmentSlot.HEAD).is(toReplace)) {
            inventory.setSlotAndDrop(SoldierEquipmentSlot.CHEST, stack);
            return stack;
        }
        return ItemStack.EMPTY;
    }
}

