/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.capability;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.bumblebee.claysoldiers.capability.ThrowHealingCapability;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.throwables.ClaySoldierSnowball;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ThrowableItemCapability {
    public static final BiFunction<ItemStack, @Nullable SoldierHoldableEffect, ThrowableItemCapability> SNOWBALL = (stack, effect) -> ClaySoldierSnowball::new;
    public static final BiFunction<ItemStack, @Nullable SoldierHoldableEffect, ThrowableItemCapability> GLISTERING_MELON_SLICE = (stack, effect) -> new ThrowHealingCapability();
    public static final Map<ItemLike, BiFunction<ItemStack, @Nullable SoldierHoldableEffect, ThrowableItemCapability>> THROWABLE_ITEM_MAP = new HashMap<Item, BiFunction<ItemStack, SoldierHoldableEffect, ThrowableItemCapability>>(Map.of(Items.SNOWBALL, SNOWBALL, Items.GLISTERING_MELON_SLICE, GLISTERING_MELON_SLICE));

    @NotNull
    public Projectile createProjectile(Level var1, LivingEntity var2, SoldierHoldableEffect var3);

    default public void performRangedAttack(AbstractClaySoldierEntity shooter, Level level, LivingEntity pTarget, SoldierHoldableEffect holdableEffect, float pVelocity) {
        Projectile projectile = this.createProjectile(level, (LivingEntity)shooter, holdableEffect);
        double deltaX = pTarget.getX() - shooter.getX();
        double deltaY = pTarget.getY(0.3333333333333333) - projectile.getY();
        double deltaZ = pTarget.getZ() - shooter.getZ();
        projectile.shoot(deltaX, deltaY, deltaZ, pVelocity * 2.0f, 0.0f);
        shooter.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (shooter.getRandom().nextFloat() * 0.4f + 0.8f));
        level.addFreshEntity((Entity)projectile);
    }
}

