/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.clayremovalcondition;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalConditionContext;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;

public abstract class RemovalCondition {
    public static final String COMPONENT_PREFIX = "clay_removal_condition.csr.";
    public static final Codec<Float> CHANCE_CODEC = CodecUtils.CHANCE_CODEC;
    private final float chance;
    private final RemovalConditionContext.Type type;

    protected RemovalCondition(float chance, RemovalConditionContext.Type type) {
        this.chance = chance;
        this.type = type;
    }

    public abstract boolean shouldRemove(AbstractClaySoldierEntity var1, RemovalConditionContext var2);

    public abstract Component getDisplayName();

    public float getChance() {
        return this.chance;
    }

    public RemovalConditionContext.Type getType() {
        return this.type;
    }

    protected boolean baseTest(RemovalConditionContext.Type toTest, RandomSource randomSource) {
        return this.type == toTest && randomSource.nextFloat() <= this.getChance();
    }

    protected static <T extends RemovalCondition> StreamCodec<ByteBuf, T> createChacneStreamCodec(Function<Float, T> factory) {
        return ByteBufCodecs.FLOAT.map(factory, RemovalCondition::getChance);
    }
}

