/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.claysoldierpredicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClayPredicate;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClayPredicatePriority;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClayPredicateSerializer;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClaySoldierInventoryQuery;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.bumblebee.claysoldiers.soldierproperties.translation.KeyableTranslatableProperty;
import net.bumblebee.claysoldiers.util.EffectHolder;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClayPredicates {
    public static final Supplier<ClayPredicateSerializer<ItemPredicate>> ITEM_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayPredicateSerializer("has_item", () -> new ClayPredicateSerializer<ItemPredicate>(ItemPredicate.CODEC, ItemPredicate.STREAM_CODEC));
    public static final Supplier<ClayPredicateSerializer<LogicPredicate>> LOGIC_PREDICATE_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayPredicateSerializer("logic", () -> new ClayPredicateSerializer<LogicPredicate>(LogicPredicate.CODEC, LogicPredicate.STREAM_CODEC));
    public static final Supplier<ClayPredicateSerializer<SoldierPropertyPredicate>> SOLDIER_HOLDABLE_PROPERTY_PREDICATE = ClaySoldiersCommon.PLATFORM.registerClayPredicateSerializer("holdable_property", () -> new ClayPredicateSerializer<SoldierPropertyPredicate>(SoldierPropertyPredicate.CODEC, SoldierPropertyPredicate.STREAM_CODEC));
    public static final Supplier<ClayPredicateSerializer<EffectPredicate>> EFFECT_PREDICATE = ClaySoldiersCommon.PLATFORM.registerClayPredicateSerializer("has_effect", () -> new ClayPredicateSerializer<EffectPredicate>(EffectPredicate.CODEC, EffectPredicate.STREAM_CODEC));
    private static final String COMPONENT_PREFIX = "clay_soldier_predicate.csr.";
    public static final String ITEM_PREDICATE_COMPONENT = "clay_soldier_predicate.csr.item_predicate";
    public static final String ITEM_PREDICATE_ANY_COMPONENT = "clay_soldier_predicate.csr.item_predicate_any";
    public static final String SOLDIER_PROPERTY_PREDICATE_COMPONENT = "clay_soldier_predicate.csr.soldier_property_predicate";
    public static final String EFFECT_PREDICATE_COMPONENT = "clay_soldier_predicate.csr.effect_predicate";
    public static final String EFFECT_PREDICATE_DURATION_COMPONENT = "clay_soldier_predicate.csr.effect_predicate.duration";
    public static final String EFFECT_PREDICATE_AMPLIFIER_COMPONENT = "clay_soldier_predicate.csr.effect_predicate.amplifier";
    public static final String EFFECT_PREDICATE_DURATION_AMPLIFIER_COMPONENT = "clay_soldier_predicate.csr.effect_predicate.duration_amplifier";
    public static final String HAS_CUSTOM_COLOR_COMPONENT = "clay_soldier_predicate.csr.custom_color_predicate";
    public static final Supplier<ClayPredicateSerializer<ConstantPredicate>> ALWAYS_TRUE_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayPredicateSerializer("always_true", () -> new ClayPredicateSerializer<ConstantPredicate>(ConstantPredicate.ALWAYS_TRUE_CODEC));
    public static final Supplier<ClayPredicateSerializer<ConstantPredicate>> HAS_CUSTOM_COLOR_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayPredicateSerializer("has_custom_color", () -> new ClayPredicateSerializer<ConstantPredicate>(ConstantPredicate.HAS_CUSTOM_COLOR_CODEC));

    private ClayPredicates() {
    }

    public static void init() {
    }

    public static class ConstantPredicate
    extends ClayPredicate<ConstantPredicate> {
        private static final Codec<ConstantPredicate> ALWAYS_TRUE_CODEC = Codec.unit(ConstantPredicate::getAlwaysTruePredicate);
        private static final Codec<ConstantPredicate> HAS_CUSTOM_COLOR_CODEC = Codec.unit(ConstantPredicate::getHasCustomColor);
        private static ConstantPredicate ALWAYS_TRUE_INSTANCE = null;
        private static ConstantPredicate CUSTOM_COLOR_INSTANCE = null;
        private final Predicate<ClaySoldierInventoryQuery> value;
        @Nullable
        private final String translatableKey;

        public static ConstantPredicate getAlwaysTruePredicate() {
            if (ALWAYS_TRUE_INSTANCE == null) {
                ALWAYS_TRUE_INSTANCE = new ConstantPredicate(ALWAYS_TRUE_SERIALIZER, s -> true, null);
            }
            return ALWAYS_TRUE_INSTANCE;
        }

        public static ConstantPredicate getHasCustomColor() {
            if (CUSTOM_COLOR_INSTANCE == null) {
                CUSTOM_COLOR_INSTANCE = new ConstantPredicate(HAS_CUSTOM_COLOR_SERIALIZER, ClaySoldierInventoryQuery::hasOffsetColor, ClayPredicates.HAS_CUSTOM_COLOR_COMPONENT);
            }
            return CUSTOM_COLOR_INSTANCE;
        }

        private ConstantPredicate(Supplier<ClayPredicateSerializer<ConstantPredicate>> serializer, Predicate<ClaySoldierInventoryQuery> value, @Nullable String displayName) {
            super(serializer);
            this.value = value;
            this.translatableKey = displayName;
        }

        @Override
        @Nullable
        public Component getDisplayName() {
            return this.translatableKey == null ? null : Component.translatable((String)this.translatableKey);
        }

        @Override
        public ClayPredicatePriority getPriority() {
            return ClayPredicatePriority.HIGH;
        }

        @Override
        public boolean test(ClaySoldierInventoryQuery soldier) {
            return this.value.test(soldier);
        }

        public String toString() {
            return "ConstantPredicate: " + (this.translatableKey == null ? "AlwaysTrue" : "Custom Color");
        }
    }

    public static class EffectPredicate
    extends ClayPredicate<EffectPredicate>
    implements EffectHolder {
        public static final Codec<EffectPredicate> CODEC = EffectHolder.getCodec(EffectPredicate::fromEffectHolder, "min");
        private static final StreamCodec<RegistryFriendlyByteBuf, EffectPredicate> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT), EffectPredicate::effectHolder, (StreamCodec)ByteBufCodecs.VAR_INT, EffectPredicate::duration, (StreamCodec)ByteBufCodecs.VAR_INT, EffectPredicate::amplifier, EffectPredicate::new);
        private final Holder<MobEffect> effect;
        private final int minDuration;
        private final int minAmplifier;

        public EffectPredicate(Holder<MobEffect> effect, int minDuration, int minAmplifier) {
            super(EFFECT_PREDICATE);
            this.effect = effect;
            this.minDuration = minDuration;
            this.minAmplifier = minAmplifier;
        }

        public EffectPredicate(Holder<MobEffect> effect) {
            this(effect, 0, 0);
        }

        @Override
        public ClayPredicatePriority getPriority() {
            return ClayPredicatePriority.HIGH;
        }

        @Override
        public boolean test(ClaySoldierInventoryQuery soldier) {
            MobEffectInstance mobEffect = soldier.getMobEffect(this.effect);
            return mobEffect != null && mobEffect.getAmplifier() >= this.minAmplifier && mobEffect.getDuration() >= this.minDuration;
        }

        @Override
        public MobEffect effect() {
            return (MobEffect)this.effect.value();
        }

        @Override
        public int duration() {
            return this.minDuration;
        }

        @Override
        public int amplifier() {
            return this.minAmplifier;
        }

        @Override
        public Holder<MobEffect> effectHolder() {
            return this.effect;
        }

        private static EffectPredicate fromEffectHolder(EffectHolder effectHolder) {
            return new EffectPredicate(effectHolder.effectHolder(), effectHolder.amplifier(), effectHolder.duration());
        }

        @Override
        public Component getDisplayName() {
            if (this.minDuration > 0 && this.minAmplifier > 0) {
                return Component.translatable((String)ClayPredicates.EFFECT_PREDICATE_DURATION_AMPLIFIER_COMPONENT, (Object[])new Object[]{this.effect().getDisplayName(), this.minDuration * 20, this.minAmplifier});
            }
            if (this.minAmplifier > 0) {
                return Component.translatable((String)ClayPredicates.EFFECT_PREDICATE_AMPLIFIER_COMPONENT, (Object[])new Object[]{this.effect().getDisplayName(), this.minAmplifier});
            }
            if (this.minDuration > 0) {
                return Component.translatable((String)ClayPredicates.EFFECT_PREDICATE_DURATION_COMPONENT, (Object[])new Object[]{this.effect().getDisplayName(), this.minDuration * 20});
            }
            return Component.translatable((String)ClayPredicates.EFFECT_PREDICATE_COMPONENT, (Object[])new Object[]{this.effect().getDisplayName()});
        }
    }

    public static class SoldierPropertyPredicate
    extends ClayPredicate<SoldierPropertyPredicate> {
        public static final Codec<SoldierPropertyPredicate> CODEC = RecordCodecBuilder.create(in -> in.group((App)PropertyTestType.CODEC.optionalFieldOf("test_type", (Object)PropertyTestType.EXIST).forGetter(p -> p.testType), (App)SoldierPropertyTypes.CODEC.fieldOf("property").forGetter(p -> p.propertyIdentifier), (App)Codec.INT.optionalFieldOf("value", (Object)-1).forGetter(p -> p.countNeeded)).apply((Applicative)in, SoldierPropertyPredicate::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SoldierPropertyPredicate> STREAM_CODEC = StreamCodec.composite(PropertyTestType.STREAM_CODEC, s -> s.testType, SoldierPropertyTypes.STREAM_CODEC, s -> s.propertyIdentifier, (StreamCodec)ByteBufCodecs.VAR_INT, s -> s.countNeeded, SoldierPropertyPredicate::new);
        private final SoldierPropertyType<?> propertyIdentifier;
        private final PropertyTestType testType;
        private final int countNeeded;

        private SoldierPropertyPredicate(PropertyTestType testType, SoldierPropertyType<?> propertyIdentifier, int count) {
            super(SOLDIER_HOLDABLE_PROPERTY_PREDICATE);
            this.propertyIdentifier = propertyIdentifier;
            this.testType = testType;
            this.countNeeded = count;
        }

        public SoldierPropertyPredicate(PropertyTestType testType, SoldierPropertyType<?> propertyIdentifier) {
            this(testType, propertyIdentifier, -1);
        }

        public static SoldierPropertyPredicate getCount(SoldierPropertyType<Collection<?>> propertyIdentifier, int count) {
            return new SoldierPropertyPredicate(PropertyTestType.COUNT, propertyIdentifier, count);
        }

        public static SoldierPropertyPredicate isExactly(SoldierPropertyType<?> propertyIdentifier, int toBe) {
            return new SoldierPropertyPredicate(PropertyTestType.IS_EXACTLY, propertyIdentifier, toBe);
        }

        @Override
        public ClayPredicatePriority getPriority() {
            return ClayPredicatePriority.LOW;
        }

        @Override
        public boolean test(ClaySoldierInventoryQuery soldier) {
            int value = soldier.allProperties().getPropertyValueAsInt(this.propertyIdentifier);
            if (this.propertyIdentifier == SoldierPropertyTypes.ATTACK_TYPE.get() && value == AttackTypeProperty.NORMAL.ordinal()) {
                value = soldier.getAttackType().ordinal();
            }
            return this.testType.test(value, this.countNeeded);
        }

        @Override
        public Component getDisplayName() {
            return this.testType.getDisplayName(this.propertyIdentifier.getDisplayName(), this.countNeeded);
        }
    }

    public static class LogicPredicate
    extends ClayPredicate<LogicPredicate> {
        public static final Codec<LogicPredicate> CODEC = RecordCodecBuilder.create(in -> in.group((App)LogicComparator.CODEC.fieldOf("operation").forGetter(LogicPredicate::getComparator), (App)CodecUtils.singularOrPluralCodecOptional(ClayPredicate.CODEC, "predicate").forGetter(LogicPredicate::getList)).apply((Applicative)in, LogicPredicate::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, LogicPredicate> STREAM_CODEC = StreamCodec.composite(LogicComparator.STREAM_CODEC, LogicPredicate::getComparator, (StreamCodec)ClayPredicate.STREAM_CODEC.apply(ByteBufCodecs.collection(HashSet::new)), s -> s.list, LogicPredicate::new);
        private final Set<ClayPredicate<?>> list;
        private final LogicComparator comparator;

        private LogicPredicate(LogicComparator comparator, Set<ClayPredicate<?>> list) {
            super(LOGIC_PREDICATE_SERIALIZER);
            this.list = list;
            this.comparator = comparator;
        }

        private Set<ClayPredicate<?>> getList() {
            return this.list;
        }

        private LogicComparator getComparator() {
            return this.comparator;
        }

        public static LogicPredicate any(Set<ClayPredicate<?>> predicates) {
            return new LogicPredicate(LogicComparator.ANY, predicates);
        }

        public static LogicPredicate all(Set<ClayPredicate<?>> predicates) {
            return new LogicPredicate(LogicComparator.ALL, predicates);
        }

        public static LogicPredicate none(Set<ClayPredicate<?>> predicates) {
            return new LogicPredicate(LogicComparator.NONE, predicates);
        }

        public static LogicPredicate not(ClayPredicate<?> predicates) {
            return new LogicPredicate(LogicComparator.NOT, Set.of(predicates));
        }

        @Override
        public ClayPredicatePriority getPriority() {
            return ClayPredicatePriority.MULTI;
        }

        @Override
        public boolean test(ClaySoldierInventoryQuery soldier) {
            return this.comparator.test(this.list.stream().map(p -> p.test(soldier)).toList());
        }

        @Override
        @Nullable
        public Component getDisplayName() {
            MutableComponent mutableComponent = this.comparator.getDisplayName().copy().withStyle(ChatFormatting.DARK_GRAY);
            List<Component> components = this.list.stream().map(ClayPredicate::getDisplayName).filter(Objects::nonNull).toList();
            for (int i = 0; i < components.size(); ++i) {
                if (i == 0) {
                    mutableComponent.append(" ");
                } else {
                    mutableComponent.append(", ");
                }
                mutableComponent.append(components.get(i));
            }
            return components.isEmpty() ? null : mutableComponent;
        }

        public String toString() {
            return "LogicPredicate(%s: %s)".formatted(this.comparator.serializedName, this.list);
        }
    }

    public static class ItemPredicate
    extends ClayPredicate<ItemPredicate> {
        private static final Codec<Either<ItemPredicateSlot, SoldierEquipmentSlot>> CODEC_SLOT = Codec.either(ItemPredicateSlot.CODEC, SoldierEquipmentSlot.CODEC);
        public static final Codec<ItemPredicate> CODEC = RecordCodecBuilder.create(in -> in.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(ItemPredicate::getItem), (App)CODEC_SLOT.fieldOf("slot").forGetter(ItemPredicate::getSlot)).apply((Applicative)in, ItemPredicate::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemPredicate> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), ItemPredicate::getItem, (StreamCodec)ByteBufCodecs.either(ItemPredicateSlot.STREAM_CODEC, SoldierEquipmentSlot.STREAM_CODEC), ItemPredicate::getSlot, ItemPredicate::new);
        private final Item item;
        private final SoldierEquipmentSlot slot;
        @Nullable
        private final ItemPredicateSlot specialSlot;

        private ItemPredicate(Item item, Either<ItemPredicateSlot, SoldierEquipmentSlot> either) {
            super(ITEM_SERIALIZER);
            this.item = item;
            if (either.left().isPresent()) {
                this.specialSlot = (ItemPredicateSlot)either.left().get();
                this.slot = null;
            } else {
                this.slot = (SoldierEquipmentSlot)either.right().orElseThrow();
                this.specialSlot = null;
            }
        }

        public ItemPredicate(Item item, SoldierEquipmentSlot slot) {
            this(item, (Either<ItemPredicateSlot, SoldierEquipmentSlot>)Either.right((Object)slot));
        }

        public static ItemPredicate any(Item item) {
            return new ItemPredicate(item, (Either<ItemPredicateSlot, SoldierEquipmentSlot>)Either.left((Object)ItemPredicateSlot.ANY_SLOT));
        }

        public static ItemPredicate suitable(Item item) {
            return new ItemPredicate(item, (Either<ItemPredicateSlot, SoldierEquipmentSlot>)Either.left((Object)ItemPredicateSlot.SUITABLE));
        }

        private Either<ItemPredicateSlot, SoldierEquipmentSlot> getSlot() {
            return this.slot != null ? Either.right((Object)this.slot) : Either.left((Object)this.specialSlot);
        }

        public Item getItem() {
            return this.item;
        }

        @Override
        public ClayPredicatePriority getPriority() {
            return ClayPredicatePriority.HIGH;
        }

        @Override
        @Nullable
        public Component getDisplayName() {
            if (this.slot == null) {
                assert (this.specialSlot != null);
                return Component.translatable((String)ClayPredicates.ITEM_PREDICATE_ANY_COMPONENT, (Object[])new Object[]{this.item.getDescription(), this.specialSlot.getDisplayName()}).withStyle(ChatFormatting.DARK_GRAY);
            }
            return Component.translatable((String)ClayPredicates.ITEM_PREDICATE_COMPONENT, (Object[])new Object[]{this.item.getDescription(), this.slot.getDisplayName()}).withStyle(ChatFormatting.DARK_GRAY);
        }

        @Override
        public boolean test(ClaySoldierInventoryQuery soldier) {
            if (this.slot != null) {
                return soldier.getItemBySlot(this.slot).stack().is(this.item);
            }
            if (this.specialSlot == ItemPredicateSlot.ANY_SLOT) {
                for (ItemStack stack : soldier.getAllSlots()) {
                    if (!stack.is(this.item)) continue;
                    return true;
                }
                return false;
            }
            SoldierHoldableEffect effect = ClaySoldiersCommon.DATA_MAP.getEffect(this.item);
            if (effect != null) {
                for (SoldierEquipmentSlot possibleSlot : effect.slots()) {
                    if (!soldier.getItemBySlot(possibleSlot).stack().isEmpty()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static enum LogicComparator implements StringRepresentable
    {
        ANY("any", list -> list.contains(true)),
        ALL("all", list -> !list.contains(false)),
        NONE("none", list -> !list.contains(true)),
        NOT("not", list -> (Boolean)list.getFirst() == false);

        public static final StringRepresentable.StringRepresentableCodec<LogicComparator> CODEC;
        private static final StreamCodec<FriendlyByteBuf, LogicComparator> STREAM_CODEC;
        private final String serializedName;
        private final Predicate<List<Boolean>> predicate;

        private LogicComparator(String name, Predicate<List<Boolean>> predicate) {
            this.serializedName = name;
            this.predicate = predicate;
        }

        public Component getDisplayName() {
            return Component.translatable((String)("clay_soldier_predicate.csr.logic_comparator." + this.serializedName));
        }

        @NotNull
        public String getSerializedName() {
            return this.serializedName;
        }

        public boolean test(List<Boolean> list) {
            return this.predicate.test(list);
        }

        static {
            CODEC = StringRepresentable.fromEnum(LogicComparator::values);
            STREAM_CODEC = CodecUtils.createEnumStreamCodec(LogicComparator.class);
        }
    }

    public static enum PropertyTestType implements StringRepresentable
    {
        INCREASE("increase", i -> i > 0),
        DECREASE("decrease", i -> i < 0),
        EXIST("exist", i -> i != 0),
        IS_EXACTLY("exactly", (n, c) -> n == c),
        COUNT("count", (n, c) -> n >= c);

        public static final Codec<PropertyTestType> CODEC;
        private static final StreamCodec<FriendlyByteBuf, PropertyTestType> STREAM_CODEC;
        private final String serializedName;
        private final BiIntPredicate predicate;

        private PropertyTestType(String serializedName, BiIntPredicate predicate) {
            this.serializedName = serializedName;
            this.predicate = predicate;
        }

        private PropertyTestType(String serializedName, IntPredicate predicate) {
            this(serializedName, (int number, int ignored) -> predicate.test(number));
        }

        public Component getDisplayName(Component propertyName, int count) {
            return Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{propertyName, "" + count}).withStyle(ChatFormatting.DARK_GRAY);
        }

        public String getDescriptionId() {
            return "clay_soldier_predicate.csr..property_test_type." + this.serializedName;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        public boolean test(int number, int shouldBe) {
            return this.predicate.test(number, shouldBe);
        }

        static {
            CODEC = StringRepresentable.fromEnum(PropertyTestType::values);
            STREAM_CODEC = CodecUtils.createEnumStreamCodec(PropertyTestType.class);
        }

        @FunctionalInterface
        private static interface BiIntPredicate {
            public boolean test(int var1, int var2);
        }
    }

    public static enum ItemPredicateSlot implements StringRepresentable,
    KeyableTranslatableProperty
    {
        ANY_SLOT("any"),
        SUITABLE("suitable");

        private static final String ITEM_PREDICATE_SPECIAL = "clay_soldier_predicate.csr.item_predicate_special.any.";
        private static final Codec<ItemPredicateSlot> CODEC;
        private static final StreamCodec<FriendlyByteBuf, ItemPredicateSlot> STREAM_CODEC;
        private final String serializedName;

        private ItemPredicateSlot(String serializedName) {
            this.serializedName = serializedName;
        }

        @Override
        public String translatableKey() {
            return ITEM_PREDICATE_SPECIAL + this.serializedName;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ItemPredicateSlot::values);
            STREAM_CODEC = CodecUtils.createEnumStreamCodec(ItemPredicateSlot.class);
        }
    }
}

