/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.bumblebee.claysoldiers.commands.DefaultedResourceLocationArgument;
import net.bumblebee.claysoldiers.entity.ClayMobTeamOwnerEntity;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.boss.ClaySoldierBossEquipment;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.item.claymobspawn.ClaySoldierSpawnItem;
import net.bumblebee.claysoldiers.soldieritemtypes.SoldierItemType;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.team.TeamLoyaltyManger;
import net.bumblebee.claysoldiers.team.TeamPlayerData;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class ClaySoldierCommands {
    public static final String COMMAND_TEAM_SINGLE_SUCCESS = "commands.csr.change_team.success.single";
    public static final String COMMAND_TEAM_MULTIPLE_SUCCESS = "commands.csr.change_team.success.multiple";
    public static final String COMMAND_TEAM_FAILURE = "commands.csr.change_team.failure";
    public static final String COMMAND_TEAM_ITEM_SUCCESS = "commands.csr.change_team.item.success";
    public static final String COMMAND_EXECUTED_BY_PLAYER = "commands.csr.change_team.item.failure";
    public static final String COMMAND_LOADED_TEAMS_SUCCESS = "commands.csr.loaded_teams";
    public static final String COMMAND_SHOW_TEAM_ALLEGIANCE_SUCCESS = "commands.csr.team_allegiance";
    public static final String COMMAND_SHOW_TEAM_ALLEGIANCE_EMPTY = "commands.csr.team_allegiance.empty";
    public static final String COMMAND_ITEM_SET_ERROR = "commands.csr.spawn_item_set.error";
    public static final String COMMAND_ITEM_SET_FAILURE = "commands.csr.spawn_item_set.failure";
    public static final String COMMAND_TEAM_LOYALTY_FAILURE = "commands.csr.team_loyalty.set.failure";
    public static final String COMMAND_TEAM_LOYALTY_REMOVE_FAILURE = "commands.csr.team_loyalty.remove.failure";
    public static final String COMMAND_TEAM_LOYALTY_REMOVE = "commands.csr.team_loyalty.remove.success";
    public static final String COMMAND_TEAM_LOYALTY_SET = "commands.csr.team_loyalty.set.success";
    public static final String ENABLING_DATAPACK = "commands.csr.datapack.enabling";
    public static final String DISABLING_DATAPACK = "commands.csr.datapack.disabing";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        LiteralArgumentBuilder csrCommand = Commands.literal((String)"csr");
        csrCommand.then(((LiteralArgumentBuilder)Commands.literal((String)"items").requires(c -> c.hasPermission(2))).then(Commands.argument((String)"set", (ArgumentType)DefaultedResourceLocationArgument.itemType(context)).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> ClaySoldierCommands.spawnItems((CommandContext<CommandSourceStack>)c, true))).then(Commands.literal((String)"uniform").executes(c -> ClaySoldierCommands.spawnItems((CommandContext<CommandSourceStack>)c, false))))));
        csrCommand.then(((LiteralArgumentBuilder)Commands.literal((String)"team").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").requires(c -> c.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"team", (ArgumentType)DefaultedResourceLocationArgument.all(context)).executes(ClaySoldierCommands::setTeamCommand)))).then(Commands.literal((String)"item").then(Commands.argument((String)"team", (ArgumentType)DefaultedResourceLocationArgument.all(context)).executes(ClaySoldierCommands::setTeamHandCommand))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"loyalty").requires(c -> c.hasPermission(0))).executes(ClaySoldierCommands::showTeamAllegiance)).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(c -> c.hasPermission(4))).then(Commands.argument((String)"team", (ArgumentType)DefaultedResourceLocationArgument.all(context)).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(c -> ClaySoldierCommands.setTeamLoyalty((CommandContext<CommandSourceStack>)c, (Player)EntityArgument.getPlayer((CommandContext)c, (String)"player"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(c -> c.hasPermission(4))).then(Commands.argument((String)"team", (ArgumentType)DefaultedResourceLocationArgument.all(context)).executes(c -> ClaySoldierCommands.setTeamLoyalty((CommandContext<CommandSourceStack>)c, null))))));
        csrCommand.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"boss").requires(c -> c.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"normal").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<CommandSourceStack>)c, ClaySoldierBossEquipment.NORMAL, 0, null, false))).then(((RequiredArgumentBuilder)Commands.argument((String)"team", (ArgumentType)DefaultedResourceLocationArgument.all(context)).executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<CommandSourceStack>)c, ClaySoldierBossEquipment.NORMAL, 0, DefaultedResourceLocationArgument.key("team", (CommandContext<CommandSourceStack>)c), false))).then(Commands.literal((String)"waxed").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<CommandSourceStack>)c, ClaySoldierBossEquipment.NORMAL, 0, DefaultedResourceLocationArgument.key("team", (CommandContext<CommandSourceStack>)c), true))))).then(Commands.literal((String)"waxed").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<CommandSourceStack>)c, ClaySoldierBossEquipment.NORMAL, 0, null, true))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"vampire").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<CommandSourceStack>)c, ClaySoldierBossEquipment.VAMPIRE, 0, null, false))).then(((RequiredArgumentBuilder)Commands.argument((String)"team", (ArgumentType)DefaultedResourceLocationArgument.all(context)).executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<CommandSourceStack>)c, ClaySoldierBossEquipment.VAMPIRE, 0, DefaultedResourceLocationArgument.key("team", (CommandContext<CommandSourceStack>)c), false))).then(Commands.literal((String)"waxed").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<CommandSourceStack>)c, ClaySoldierBossEquipment.VAMPIRE, 0, DefaultedResourceLocationArgument.key("team", (CommandContext<CommandSourceStack>)c), true))))).then(Commands.literal((String)"waxed").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<CommandSourceStack>)c, ClaySoldierBossEquipment.VAMPIRE, 0, null, true))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"zombie").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<CommandSourceStack>)c, ClaySoldierBossEquipment.ZOMBIE, 0, null, false))).then(((RequiredArgumentBuilder)Commands.argument((String)"team", (ArgumentType)DefaultedResourceLocationArgument.all(context)).executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<CommandSourceStack>)c, ClaySoldierBossEquipment.ZOMBIE, 0, DefaultedResourceLocationArgument.key("team", (CommandContext<CommandSourceStack>)c), false))).then(Commands.literal((String)"waxed").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<CommandSourceStack>)c, ClaySoldierBossEquipment.ZOMBIE, 0, DefaultedResourceLocationArgument.key("team", (CommandContext<CommandSourceStack>)c), true))))).then(Commands.literal((String)"waxed").executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<CommandSourceStack>)c, ClaySoldierBossEquipment.ZOMBIE, 0, null, true))))).then(Commands.literal((String)"random").then(Commands.argument((String)"weight", (ArgumentType)IntegerArgumentType.integer((int)0, (int)25)).executes(c -> ClaySoldierCommands.summonBossClaySoldier((CommandContext<CommandSourceStack>)c, ClaySoldierBossEquipment.RANDOM, IntegerArgumentType.getInteger((CommandContext)c, (String)"weight"), null, false)))));
        dispatcher.register(csrCommand);
    }

    private static int spawnItems(CommandContext<CommandSourceStack> command, boolean random) {
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        SoldierItemType type = (SoldierItemType)((CommandSourceStack)command.getSource()).registryAccess().registryOrThrow(ModRegistries.SOLDIER_ITEM_TYPES).get((ResourceLocation)command.getArgument("set", ResourceLocation.class));
        if (type == null) {
            source.sendFailure((Component)Component.translatable((String)COMMAND_ITEM_SET_ERROR));
            return -1;
        }
        int count = IntegerArgumentType.getInteger(command, (String)"amount");
        Vec3 pos = source.getPosition();
        RandomSource randomSource = random ? source.getLevel().getRandom() : RandomSource.create((long)42L);
        NonNullList<ItemStack> list = type.getItems(randomSource, count);
        if (list.isEmpty()) {
            source.sendFailure((Component)Component.translatable((String)COMMAND_ITEM_SET_FAILURE));
            return -1;
        }
        list.forEach(itemStack -> ClaySoldierCommands.dropDelayedItemStack((Level)source.getLevel(), pos.x, pos.y, pos.z, itemStack));
        source.sendSuccess(type::getDisplayName, true);
        return 1;
    }

    private static void dropDelayedItemStack(Level level, double x, double y, double z, ItemStack stack) {
        double width = EntityType.ITEM.getWidth();
        double d1 = 1.0 - width;
        double d2 = width / 2.0;
        double d3 = Math.floor(x) + level.random.nextDouble() * d1 + d2;
        double d4 = Math.floor(y) + level.random.nextDouble() * d1;
        double d5 = Math.floor(z) + level.random.nextDouble() * d1 + d2;
        while (!stack.isEmpty()) {
            ItemEntity itementity = new ItemEntity(level, d3, d4, d5, stack.split(level.random.nextInt(21) + 10));
            itementity.setDeltaMovement(level.random.triangle(0.0, 0.11485000171139836), level.random.triangle(0.2, 0.11485000171139836), level.random.triangle(0.0, 0.11485000171139836));
            itementity.setPickUpDelay(60);
            level.addFreshEntity((Entity)itementity);
        }
    }

    private static int setTeamCommand(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
        List<ClayMobTeamOwnerEntity> entities = EntityArgument.getEntities(command, (String)"targets").stream().filter(ClayMobTeamOwnerEntity.class::isInstance).map(ClayMobTeamOwnerEntity.class::cast).toList();
        RegistryAccess registries = ((CommandSourceStack)command.getSource()).registryAccess();
        ResourceLocation team = DefaultedResourceLocationArgument.key("team", command);
        for (ClayMobTeamOwnerEntity entity : entities) {
            entity.setClayTeamType(team);
        }
        if (entities.size() == 1) {
            ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.translatable((String)COMMAND_TEAM_SINGLE_SUCCESS, (Object[])new Object[]{ClayMobTeamManger.getFromKeyAssumeValid(team, registries).getDisplayNameWithColor(ColorHelper::getColorStatic)}), true);
        } else if (entities.size() > 1) {
            ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.translatable((String)COMMAND_TEAM_MULTIPLE_SUCCESS, (Object[])new Object[]{entities.size(), ClayMobTeamManger.getFromKeyAssumeValid(team, registries).getDisplayNameWithColor(ColorHelper::getColorStatic)}), true);
        } else {
            ((CommandSourceStack)command.getSource()).sendFailure((Component)Component.translatable((String)COMMAND_TEAM_FAILURE));
        }
        return entities.size();
    }

    private static int setTeamLoyalty(CommandContext<CommandSourceStack> command, @Nullable Player player) {
        ResourceLocation teamId = DefaultedResourceLocationArgument.key("team", command);
        Component team = ClayMobTeamManger.getFromKeyOrError(teamId, (HolderLookup.Provider)((CommandSourceStack)command.getSource()).registryAccess()).getDisplayNameWithColor(ColorHelper::getColorStatic);
        if (TeamLoyaltyManger.setTeamPlayer(((CommandSourceStack)command.getSource()).getLevel(), teamId, player)) {
            if (player == null) {
                ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.translatable((String)COMMAND_TEAM_LOYALTY_REMOVE, (Object[])new Object[]{team}), true);
            } else {
                ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.translatable((String)COMMAND_TEAM_LOYALTY_SET, (Object[])new Object[]{team, player.getDisplayName()}), true);
            }
            return 1;
        }
        if (player == null) {
            ((CommandSourceStack)command.getSource()).sendFailure((Component)Component.translatable((String)COMMAND_TEAM_LOYALTY_REMOVE_FAILURE, (Object[])new Object[]{team}));
        } else {
            ((CommandSourceStack)command.getSource()).sendFailure((Component)Component.translatable((String)COMMAND_TEAM_LOYALTY_FAILURE, (Object[])new Object[]{team, player.getDisplayName()}));
        }
        return -1;
    }

    private static int setTeamHandCommand(CommandContext<CommandSourceStack> command) {
        ResourceLocation team = DefaultedResourceLocationArgument.key("team", command);
        ServerPlayer player = ((CommandSourceStack)command.getSource()).getPlayer();
        if (player == null) {
            ((CommandSourceStack)command.getSource()).sendFailure((Component)Component.translatable((String)COMMAND_EXECUTED_BY_PLAYER));
            return -1;
        }
        int set = -1;
        ItemStack mainHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack offHand = player.getItemInHand(InteractionHand.OFF_HAND);
        if (ClaySoldierCommands.itemIsClayDoll(mainHand)) {
            ClaySoldierSpawnItem.setClayMobTeam(mainHand, team, (HolderLookup.Provider)((CommandSourceStack)command.getSource()).registryAccess());
            set = 1;
        }
        if (ClaySoldierCommands.itemIsClayDoll(offHand)) {
            ClaySoldierSpawnItem.setClayMobTeam(offHand, team, (HolderLookup.Provider)((CommandSourceStack)command.getSource()).registryAccess());
            set = set == -1 ? 1 : 2;
        }
        ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.translatable((String)COMMAND_TEAM_ITEM_SUCCESS, (Object[])new Object[]{ClayMobTeamManger.getFromKeyAssumeValid(team, ((CommandSourceStack)command.getSource()).registryAccess()).getDisplayNameWithColor(ColorHelper::getColorStatic)}), true);
        return set;
    }

    private static boolean itemIsClayDoll(ItemStack stack) {
        return stack.is(ModItems.CLAY_SOLDIER.asItem());
    }

    private static int summonBossClaySoldier(CommandContext<CommandSourceStack> command, ClaySoldierBossEquipment equipment, int weight, @Nullable ResourceLocation team, boolean waxed) {
        BossClaySoldierEntity boss = (BossClaySoldierEntity)ModEntityTypes.BOSS_CLAY_SOLDIER_ENTITY.get().create((Level)((CommandSourceStack)command.getSource()).getLevel());
        if (boss == null) {
            return -1;
        }
        boss.moveTo(((CommandSourceStack)command.getSource()).getPosition());
        equipment.setUp(boss, weight, team, waxed);
        ((CommandSourceStack)command.getSource()).getLevel().addFreshEntity((Entity)boss);
        return 1;
    }

    private static int showTeamAllegiance(CommandContext<CommandSourceStack> command) {
        ServerLevel level = ((CommandSourceStack)command.getSource()).getLevel();
        Counter counter = new Counter();
        TeamPlayerData teamDataMap = TeamLoyaltyManger.getTeamPlayerData(level);
        teamDataMap.forEach((team, playerData) -> {
            Player player = level.getPlayerByUUID(playerData.getUUID());
            Component teamName = ClayMobTeamManger.getFromKeyAssumeValid(team, ((CommandSourceStack)command.getSource()).registryAccess()).getDisplayNameWithColor(ColorHelper::getColorStatic);
            counter.add();
            if (player != null) {
                teamDataMap.updatePlayerName((ResourceLocation)team, player);
                ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.translatable((String)COMMAND_SHOW_TEAM_ALLEGIANCE_SUCCESS, (Object[])new Object[]{teamName, player.getDisplayName()}), false);
            } else {
                ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.translatable((String)COMMAND_SHOW_TEAM_ALLEGIANCE_SUCCESS, (Object[])new Object[]{teamName, playerData.getLastDisplayName()}), false);
            }
        });
        if (counter.count == 0) {
            ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.translatable((String)COMMAND_SHOW_TEAM_ALLEGIANCE_EMPTY), false);
        }
        return counter.count - 1;
    }

    private static class Counter {
        int count = 0;

        private Counter() {
        }

        private void add() {
            ++this.count;
        }
    }
}

