/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.ClaySoldiersNeoForge;
import net.bumblebee.claysoldiers.datagen.ModBlockStateProvider;
import net.bumblebee.claysoldiers.datagen.ModDataMapAndTagProvider;
import net.bumblebee.claysoldiers.datagen.ModDataMapProvider;
import net.bumblebee.claysoldiers.datagen.ModDatapackProvider;
import net.bumblebee.claysoldiers.datagen.ModItemModelProvider;
import net.bumblebee.claysoldiers.datagen.ModLangProvider;
import net.bumblebee.claysoldiers.datagen.ModLoottableProvider;
import net.bumblebee.claysoldiers.datagen.ModParticleProvider;
import net.bumblebee.claysoldiers.datagen.ModRecipeProvider;
import net.bumblebee.claysoldiers.datagen.tags.ModBlockTagsProvider;
import net.bumblebee.claysoldiers.datagen.tags.ModItemTagProvider;
import net.bumblebee.claysoldiers.datagen.tags.ModTagProvider;
import net.bumblebee.claysoldiers.integration.curios.ModCuriosProvider;
import net.minecraft.DetectedVersion;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGenerators {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"CSR DataGeneration");

    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        helper.trackGenerated(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_soldier_holdable"), PackType.SERVER_DATA, ".json", "tags/item");
        helper.trackGenerated(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_hurt"), PackType.SERVER_DATA, ".json", "damage_type");
        helper.trackGenerated(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_on_fire"), PackType.SERVER_DATA, ".json", "damage_type");
        PackOutput neoforge = new PackOutput(Path.of(packOutput.getOutputFolder().toString().replace("common", "neoforge"), new String[0]));
        PackOutput fabric = new PackOutput(Path.of(packOutput.getOutputFolder().toString().replace("common", "fabric"), new String[0]));
        LOGGER.info("Common PackOut: {}", (Object)packOutput.getOutputFolder());
        LOGGER.info("Fabric PackOut: {}", (Object)fabric.getOutputFolder());
        LOGGER.info("NeoForge PackOut: {}", (Object)neoforge.getOutputFolder());
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)ModDatapackProvider.builtin(packOutput, lookupProvider));
        ModTagProvider.getTagProviders(packOutput, lookupProvider, helper).forEach(tag -> generator.addProvider(event.includeServer(), (DataProvider)tag));
        ModBlockTagsProvider blockProvider = new ModBlockTagsProvider(packOutput, lookupProvider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockProvider.contentsGetter(), helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLangProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModParticleProvider(packOutput, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModBlockStateProvider(packOutput, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLoottableProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModCuriosProvider(neoforge, helper, lookupProvider));
        DataGenerator.PackGenerator featurePack = generator.getBuiltinDatapack(event.includeServer(), "csr", "blueprint_pack");
        featurePack.addProvider(packOut -> PackMetadataGenerator.forFeaturePack((PackOutput)new PackOutput(neoforge.getOutputFolder(PackOutput.Target.DATA_PACK).resolve("csr").resolve("datapacks").resolve("blueprint_pack")), (Component)Component.translatable((String)ClaySoldiersCommon.BLUEPRINT_PACK_DESCRIPTION), (FeatureFlagSet)FeatureFlagSet.of((FeatureFlag)ClaySoldiersNeoForge.BLUEPRINT_FLAG)));
        generator.addProvider(event.includeServer(), (DataProvider)new PackMetadataGenerator(new PackOutput(fabric.getOutputFolder().resolve("data/datapacks").resolve("blueprint_pack"))).add(PackMetadataSection.TYPE, (Object)new PackMetadataSection((Component)Component.translatable((String)ClaySoldiersCommon.BLUEPRINT_PACK_DESCRIPTION), DetectedVersion.BUILT_IN.getPackVersion(PackType.SERVER_DATA))));
        DataGenerators.itemsDataPack(packOutput.getOutputFolder(), event);
    }

    private static void itemsDataPack(Path output, GatherDataEvent event) {
        PackOutput path = new PackOutput(output.resolve("data/datapacks").resolve("csr_default_datapack"));
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new CustomPackMetadataProvider(path).add(PackMetadataSection.TYPE, new PackMetadataSection((Component)Component.translatable((String)ClaySoldiersCommon.CSR_DEFAULT_PACK_DESCRIPTION), DetectedVersion.BUILT_IN.getPackVersion(PackType.SERVER_DATA))));
        generator.addProvider(event.includeServer(), (DataProvider)ModDatapackProvider.datapack(path, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModDataMapAndTagProvider(path, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModDataMapProvider(path, lookupProvider));
    }

    private static class CustomPackMetadataProvider
    implements DataProvider {
        private final PackOutput output;
        private final Map<String, Supplier<JsonElement>> elements = new HashMap<String, Supplier<JsonElement>>();

        public CustomPackMetadataProvider(PackOutput output) {
            this.output = output;
        }

        public <T> CustomPackMetadataProvider add(MetadataSectionType<T> type, T value) {
            this.elements.put(type.getMetadataSectionName(), () -> type.toJson(value));
            return this;
        }

        public CompletableFuture<?> run(CachedOutput output) {
            JsonObject jsonobject = new JsonObject();
            this.elements.forEach((p_249290_, p_251317_) -> jsonobject.add(p_249290_, (JsonElement)p_251317_.get()));
            return DataProvider.saveStable((CachedOutput)output, (JsonElement)jsonobject, (Path)this.output.getOutputFolder().resolve("pack.mcmeta"));
        }

        public String getName() {
            return "Custom Pack Metadata";
        }
    }
}

