/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datagen;

import java.util.Objects;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.item.ClayBrushItem;
import net.bumblebee.claysoldiers.item.blueprint.BlueprintItem;
import net.bumblebee.claysoldiers.item.claymobspawn.ClaySoldierSpawnItem;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "csr", existingFileHelper);
    }

    protected void registerModels() {
        this.basicTool(ModItems.SHEAR_BLADE.get());
        this.basicTool(ModItems.SHARPENED_STICK.get());
        this.basicItem(ModItems.BRICKED_CLAY_SOLDIER.get());
        this.basicItem(ModItems.CLAY_DISRUPTOR.get());
        this.basicItem(ModItems.TERRACOTTA_DISRUPTOR.get());
        this.basicItem(ModItems.CLAY_COOKIE.get());
        this.basicItem((Item)ModItems.CLAY_GOGGLES.get());
        this.basicItem(ModItems.TEST_ITEM.get());
        this.clayBrush();
        this.basicItem(ModItems.BLUEPRINT_PAGE.get());
        this.blueprint();
        this.basicSoldier(ModItems.CLAY_SOLDIER.get());
        this.basicItem(ModItems.CAKE_HORSE.get());
        this.basicItem(ModItems.GRASS_HORSE.get());
        this.basicItem(ModItems.SNOW_HORSE.get());
        this.basicItem(ModItems.MYCELIUM_HORSE.get());
        this.basicItem(ModItems.CAKE_PEGASUS.get());
        this.basicItem(ModItems.GRASS_PEGASUS.get());
        this.basicItem(ModItems.SNOW_PEGASUS.get());
        this.basicItem(ModItems.MYCELIUM_PEGASUS.get());
        this.basicItem(ModItems.CLAY_POUCH.get()).texture("layer1", this.getDefaultItemTextureLocation(BuiltInRegistries.ITEM.getKey((Object)ModItems.CLAY_POUCH.get())).withSuffix("_cross"));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BuiltInRegistries.ITEM.getKey((Object)ModItems.CLAY_STAFF.get()).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 30.0f, 0.0f).translation(11.0f, 17.0f, 4.5f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, -30.0f, 0.0f).translation(11.0f, 17.0f, 4.5f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(-3.0f, 17.0f, 1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(13.0f, 17.0f, 1.0f).end().transform(ItemDisplayContext.GUI).rotation(15.0f, -25.0f, -5.0f).translation(2.0f, 6.0f, 0.0f).scale(0.65f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(-2.0f, 4.0f, -5.0f).scale(0.5f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(4.0f, 16.0f, 2.0f).scale(0.75f).end().end();
    }

    public void basicSoldier(Item item) {
        ResourceLocation location = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(location.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", ClaySoldierSpawnItem.TEXTURE_LOCATION);
    }

    public ItemModelBuilder basicTool(Item item) {
        ResourceLocation resourceLocation = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item));
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(resourceLocation.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", this.getDefaultItemTextureLocation(resourceLocation));
    }

    public ResourceLocation getDefaultItemTextureLocation(ResourceLocation location) {
        return ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("item/" + location.getPath()));
    }

    private void clayBrush() {
        ResourceLocation location = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)ModItems.CLAY_BRUSH.get()));
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(location.toString())).parent((ModelFile)new ModelFile.ExistingModelFile(ResourceLocation.withDefaultNamespace((String)"item/brush"), this.existingFileHelper))).texture("layer0", this.getDefaultItemTextureLocation(location));
        for (ClayBrushItem.Mode mode : ClayBrushItem.Mode.values()) {
            builder.override().predicate(ClayBrushItem.MODE_PROPERTY, mode.getOverrideProperty()).model((ModelFile)this.clayBrushState(location, mode)).end();
        }
    }

    private ItemModelBuilder clayBrushState(ResourceLocation itemKey, ClayBrushItem.Mode mode) {
        ResourceLocation modeLocation = itemKey.withSuffix("_" + mode.getSerializedName());
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(modeLocation.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)"item/clay_brush")))).texture("layer1", modeLocation.withPrefix("item/"));
    }

    private void blueprint() {
        ResourceLocation baseLocation = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)ModItems.BLUEPRINT.get()));
        ResourceLocation parent = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)ModItems.BLUEPRINT_PAGE.get()));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(baseLocation.toString())).parent((ModelFile)new ModelFile.ExistingModelFile(parent.withPrefix("item/"), this.existingFileHelper))).override().predicate(BlueprintItem.MARKING_PROPERTY, 0.0f).model((ModelFile)this.blueprintState(baseLocation, 0)).end().override().predicate(BlueprintItem.MARKING_PROPERTY, 0.1f).model((ModelFile)this.blueprintState(baseLocation, 1)).end().override().predicate(BlueprintItem.MARKING_PROPERTY, 0.2f).model((ModelFile)this.blueprintState(baseLocation, 2)).end();
    }

    private ItemModelBuilder blueprintState(ResourceLocation itemKey, int number) {
        ResourceLocation modeLocation = itemKey.withSuffix("_marking_" + number);
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(modeLocation.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)"item/blueprint")))).texture("layer1", modeLocation.withPrefix("item/"));
    }
}

