/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datagen;

import java.util.concurrent.CompletableFuture;
import net.bumblebee.claysoldiers.entity.variant.ClayHorseVariants;
import net.bumblebee.claysoldiers.init.ModBlocks;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.recipe.BrickedItemReviveRecipe;
import net.bumblebee.claysoldiers.recipe.ClaySoldierCookingRecipe;
import net.bumblebee.claysoldiers.recipe.ClaySoldierCraftingRecipe;
import net.bumblebee.claysoldiers.recipe.ShearBladeRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ModRecipeProvider
extends RecipeProvider {
    private static final String CLAY_HORSE_GROUP_NAME = "csr:clay_horse";
    private static final String CLAY_PEGASUS_GROUP_NAME = "csr:clay_pegasus";
    private static final String CLAY_DISRUPTOR_GROUP_NAME = "csr:clay_pegasus";

    public ModRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        SpecialRecipeBuilder.special(ClaySoldierCraftingRecipe::new).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_soldier_crafting"));
        SpecialRecipeBuilder.special(BrickedItemReviveRecipe::new).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_soldier_reviving"));
        SpecialRecipeBuilder.special(ShearBladeRecipe::new).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"shear_blade"));
        SpecialRecipeBuilder.special(bc -> ClaySoldierCookingRecipe.smelting()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_soldier_smelting"));
        SpecialRecipeBuilder.special(bc -> ClaySoldierCookingRecipe.blasting()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_soldier_blasting"));
        SpecialRecipeBuilder.special(bc -> ClaySoldierCookingRecipe.campfire()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_soldier_campfire"));
        SpecialRecipeBuilder.special(bc -> ClaySoldierCookingRecipe.smoking()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_soldier_smoking"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.CLAY_SOLDIER.get(), (int)4).define(Character.valueOf('E'), (ItemLike)Items.CLAY_BALL).define(Character.valueOf('S'), (ItemLike)Items.SOUL_SAND).pattern("E").pattern("S").unlockedBy("has_clay", ModRecipeProvider.has((ItemLike)Items.CLAY)).unlockedBy("has_clay_ball", ModRecipeProvider.has((ItemLike)Items.CLAY_BALL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)Items.SHEARS).define(Character.valueOf('E'), (ItemLike)ModItems.SHEAR_BLADE.get()).pattern("E ").pattern(" E").unlockedBy("has_shear_blade", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.SHEAR_BLADE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)ModItems.CLAY_DISRUPTOR.get()).define(Character.valueOf('C'), (ItemLike)Items.CLAY).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("CSC").pattern("CRC").group("csr:clay_pegasus").unlockedBy("has_clay", ModRecipeProvider.has((ItemLike)Items.CLAY)).unlockedBy("has_clay_ball", ModRecipeProvider.has((ItemLike)Items.CLAY_BALL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.TERRACOTTA_DISRUPTOR.get())).define(Character.valueOf('C'), ItemTags.TERRACOTTA).define(Character.valueOf('R'), ModItems.CLAY_DISRUPTOR).define(Character.valueOf('S'), (ItemLike)Items.REDSTONE).pattern("CSC").pattern("CRC").group("csr:clay_pegasus").unlockedBy("has_clay", ModRecipeProvider.has((ItemLike)Items.CLAY)).unlockedBy("has_clay_ball", ModRecipeProvider.has((ItemLike)Items.CLAY_BALL)).unlockedBy("has_terracotta", ModRecipeProvider.has((ItemLike)Items.TERRACOTTA)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.CLAY_COOKIE.get()), (int)4).define(Character.valueOf('#'), (ItemLike)Items.CLAY_BALL).define(Character.valueOf('R'), (ItemLike)Items.GHAST_TEAR).pattern("#R#").unlockedBy("has_clay_ball", ModRecipeProvider.has((ItemLike)Items.CLAY_BALL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)ModItems.CLAY_GOGGLES.get()).define(Character.valueOf('#'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('R'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('S'), (ItemLike)Items.LEATHER).pattern(" S ").pattern("#R#").unlockedBy("has_clay_ball", ModRecipeProvider.has((ItemLike)Items.CLAY_BALL)).unlockedBy("has_copper", ModRecipeProvider.has((ItemLike)Items.COPPER_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.CLAY_BRUSH.get())).define(Character.valueOf('#'), (ItemLike)Items.CLAY_BALL).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("#").pattern("C").pattern("S").unlockedBy("has_clay_ball", ModRecipeProvider.has((ItemLike)Items.CLAY_BALL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.BLUEPRINT_PAGE.get()).define(Character.valueOf('#'), (ItemLike)Items.LAPIS_LAZULI).define(Character.valueOf('C'), (ItemLike)Items.PAPER).define(Character.valueOf('S'), (ItemLike)Items.CLAY_BALL).pattern("#").pattern("C").pattern("S").unlockedBy("has_clay_ball", ModRecipeProvider.has((ItemLike)Items.CLAY_BALL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.ESCRITOIRE_BLOCK).define(Character.valueOf('#'), ModItems.BLUEPRINT_PAGE).define(Character.valueOf('C'), ItemTags.PLANKS).pattern("##").pattern("CC").pattern("CC").unlockedBy("has_blueprint", ModRecipeProvider.has(ModItems.BLUEPRINT_PAGE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)ModBlocks.EASEL_BLOCK.get()).define(Character.valueOf('#'), (ItemLike)Items.STICK).pattern(" # ").pattern("###").pattern("# #").unlockedBy("has_stick", ModRecipeProvider.has((ItemLike)Items.STICK)).unlockedBy("has_clay_ball", ModRecipeProvider.has((ItemLike)Items.CLAY_BALL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)ModBlocks.HAMSTER_WHEEL_BLOCK.get()).define(Character.valueOf('#'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('C'), (ItemLike)Items.STICK).define(Character.valueOf('S'), (ItemLike)Items.STONE).pattern(" # ").pattern("#C#").pattern("S#S").unlockedBy("has_copper_ingot", ModRecipeProvider.has((ItemLike)Items.COPPER_INGOT)).unlockedBy("has_clay_ball", ModRecipeProvider.has((ItemLike)Items.CLAY_BALL)).save(recipeOutput);
        ModRecipeProvider.clayHorseRecipe(recipeOutput, ClayHorseVariants.CAKE, (ItemLike)Items.CAKE);
        ModRecipeProvider.clayHorseRecipe(recipeOutput, ClayHorseVariants.GRASS, (ItemLike)Items.GRASS_BLOCK);
        ModRecipeProvider.clayHorseRecipe(recipeOutput, ClayHorseVariants.SNOW, (ItemLike)Items.SNOW_BLOCK);
        ModRecipeProvider.clayHorseRecipe(recipeOutput, ClayHorseVariants.MYCELIUM, (ItemLike)Items.MYCELIUM);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.SHARPENED_STICK.get()), (ItemLike)Items.STICK);
    }

    private static void clayHorseRecipe(RecipeOutput recipeOutput, ClayHorseVariants variant, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ClayHorseVariants.clayHorseByVariant(variant).get()), (int)2).define(Character.valueOf('C'), (ItemLike)Items.CLAY_BALL).define(Character.valueOf('H'), material).pattern("CHC").pattern("C C").unlockedBy("has_clay_ball", ModRecipeProvider.has((ItemLike)Items.CLAY_BALL)).group(CLAY_HORSE_GROUP_NAME).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ClayHorseVariants.clayPegasusByVariant(variant).get()), (int)2).define(Character.valueOf('C'), (ItemLike)Items.CLAY_BALL).define(Character.valueOf('H'), material).define(Character.valueOf('F'), (ItemLike)Items.FEATHER).pattern(" F ").pattern("CHC").pattern("C C").unlockedBy("has_clay_ball", ModRecipeProvider.has((ItemLike)Items.CLAY_BALL)).group("csr:clay_pegasus").save(recipeOutput);
    }
}

