/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datagen.api;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.datamap.armor.SoldierMultiWearable;
import net.bumblebee.claysoldiers.datamap.armor.SoldierWearableEffect;
import net.bumblebee.claysoldiers.init.ModDataMaps;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoi;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DataMapProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.datamaps.AdvancedDataMapType;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.DataMapValueRemover;
import org.jetbrains.annotations.Nullable;

public abstract class ClaySoldiersItemProvider
implements DataProvider {
    private final DataMapProvider dataMapProvider;
    private final DataMapProvider.Builder<SoldierHoldableEffect, Item> holdableBuilder;
    private final DataMapProvider.Builder<SoldierMultiWearable, Item> armorBuilder;
    private final DataMapProvider.Builder<SoldierPoi, Item> poiItemBuilder;
    private final DataMapProvider.Builder<SoldierPoi, Block> poiBlockBuilder;
    private final CustomItemTagsProvider itemTagsProvider;
    private final Set<Item> allItems;
    private final Set<TagKey<Item>> allTags;

    protected ClaySoldiersItemProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, String modid, ExistingFileHelper helper) {
        this.dataMapProvider = new DataMapProvider(this, packOutput, lookupProvider){

            protected void gather(HolderLookup.Provider provider) {
            }
        };
        this.itemTagsProvider = new CustomItemTagsProvider(packOutput, lookupProvider, modid, helper);
        this.holdableBuilder = this.dataMapProvider.builder(ModDataMaps.SOLDIER_HOLDABLE);
        this.poiItemBuilder = this.dataMapProvider.builder(ModDataMaps.SOLDIER_ITEM_POI);
        this.armorBuilder = this.dataMapProvider.builder(ModDataMaps.SOLDIER_ARMOR);
        this.poiBlockBuilder = this.dataMapProvider.builder(ModDataMaps.SOLDIER_BLOCK_POI);
        this.allItems = new HashSet<Item>();
        this.allTags = new HashSet<TagKey<Item>>();
    }

    private void registerAddedItem(ItemLike itemLike) {
        if (!this.allItems.add(itemLike.asItem())) {
            LOGGER.error("Added {} to DataMap twice", (Object)itemLike.asItem());
        }
    }

    private void registerAddedItemTag(TagKey<Item> tag) {
        if (!this.allTags.add(tag)) {
            LOGGER.error("Added {} to DataMap twice", tag);
        }
    }

    protected abstract void gather();

    protected void addHoldable(ItemLike item, SoldierHoldableEffect holdableEffect, ItemTagHolder ... itemTypes) {
        this.addHoldable(item, holdableEffect, TagType.HOLDABLE, itemTypes);
    }

    protected void addHoldable(TagKey<Item> tagKey, SoldierHoldableEffect holdableEffect, ItemTagHolder ... itemTypes) {
        this.addHoldable(tagKey, holdableEffect, TagType.HOLDABLE, itemTypes);
    }

    protected void addHoldable(ItemLike item, SoldierHoldableEffect holdableEffect, TagType type, ItemTagHolder ... itemTypes) {
        this.holdableBuilder.add(BuiltInRegistries.ITEM.getKey((Object)item.asItem()), (Object)holdableEffect, false, new ICondition[0]);
        this.itemTagsProvider.getTag(type).add((Object)item.asItem());
        this.addItemToItemTypes(item.asItem(), itemTypes);
        this.warnHoldableEffect(item.asItem().toString(), holdableEffect, itemTypes);
        this.registerAddedItem(item);
    }

    protected void addHoldable(TagKey<Item> tagKey, SoldierHoldableEffect holdableEffect, TagType type, ItemTagHolder ... itemTypes) {
        this.holdableBuilder.add(tagKey, (Object)holdableEffect, false, new ICondition[0]);
        this.itemTagsProvider.getTag(type).addTag(tagKey);
        this.addItemToItemTypes(tagKey, itemTypes);
        this.warnHoldableEffect(tagKey.toString(), holdableEffect, itemTypes);
        this.registerAddedItemTag(tagKey);
    }

    protected void addWearable(ItemLike item, SoldierHoldableEffect holdableEffect, SoldierWearableEffect wearableEffect, ItemTagHolder ... itemTypes) {
        this.addHoldable(item, holdableEffect, TagType.ARMOR, itemTypes);
        SoldierMultiWearable.Builder builder = SoldierMultiWearable.of();
        for (SoldierEquipmentSlot slot : holdableEffect.slots()) {
            builder.put(slot, wearableEffect);
        }
        if (builder.wearableSize() >= 1) {
            this.armorBuilder.add(BuiltInRegistries.ITEM.getKey((Object)item.asItem()), (Object)builder.build(), false, new ICondition[0]);
        }
    }

    protected void addWearable(ItemLike item, SoldierHoldableEffect holdableEffect, SoldierMultiWearable wearableEffect, ItemTagHolder ... itemTypes) {
        this.armorBuilder.add(BuiltInRegistries.ITEM.getKey((Object)item.asItem()), (Object)wearableEffect, false, new ICondition[0]);
        this.addHoldable(item, holdableEffect, TagType.ARMOR, itemTypes);
    }

    protected void addWearable(TagKey<Item> item, SoldierHoldableEffect holdableEffect, SoldierMultiWearable wearableEffect, ItemTagHolder ... itemTypes) {
        this.addHoldable(item, holdableEffect, TagType.ARMOR, itemTypes);
        this.armorBuilder.add(item, (Object)wearableEffect, false, new ICondition[0]);
    }

    protected void addSoldierItemPoi(ItemLike item, SoldierPoi soldierPoi) {
        this.poiItemBuilder.add(BuiltInRegistries.ITEM.getKey((Object)item.asItem()), (Object)soldierPoi, false, new ICondition[0]);
        this.itemTagsProvider.getTag(ModTags.Items.SOLDIER_POI).add((Object)item.asItem());
        this.registerAddedItem(item);
    }

    protected void addSoldierItemPoi(TagKey<Item> itemTag, SoldierPoi soldierPoi) {
        this.poiItemBuilder.add(itemTag, (Object)soldierPoi, false, new ICondition[0]);
        this.itemTagsProvider.getTag(ModTags.Items.SOLDIER_POI).addTag(itemTag);
        this.registerAddedItemTag(itemTag);
    }

    protected void addSoldierBlockPoi(Block poi, SoldierPoi soldierPoi) {
        this.poiBlockBuilder.add(BuiltInRegistries.BLOCK.getKey((Object)poi), (Object)soldierPoi, false, new ICondition[0]);
        this.itemTagsProvider.getTag(ModTags.Items.SOLDIER_POI).add((Object)poi.asItem());
    }

    private void warnHoldableEffect(String name, SoldierHoldableEffect effect, ItemTagHolder[] types) {
        effect.getRemovalConditions().forEach(r -> {
            if (r.getChance() <= 0.0f) {
                ClaySoldiersCommon.LOGGER.warn("DataMap: Building {} with a RemovalCondition with chance 0", (Object)name);
            }
        });
        if (!effect.slots().isEmpty() && types.length == 0) {
            ClaySoldiersCommon.LOGGER.warn("DataMap: {} has no SoldierItemTypes but can be equipped.", (Object)name);
        }
    }

    private void addItemToItemTypes(Item item, ItemTagHolder ... itemTypes) {
        for (ItemTagHolder type : itemTypes) {
            this.itemTagsProvider.getTag(type.getTag()).add((Object)item);
        }
    }

    private void addItemToItemTypes(TagKey<Item> item, ItemTagHolder ... itemTypes) {
        for (ItemTagHolder type : itemTypes) {
            this.itemTagsProvider.getTag(type.getTag()).addTag(item);
        }
    }

    protected IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> tag(TagKey<Item> tag) {
        return this.itemTagsProvider.getTag(tag);
    }

    protected <T, R> DataMapProvider.Builder<T, R> builder(DataMapType<R, T> type) {
        return this.dataMapProvider.builder(type);
    }

    protected <T, R, VR extends DataMapValueRemover<R, T>> DataMapProvider.AdvancedBuilder<T, R, VR> builder(AdvancedDataMapType<R, T, VR> type) {
        return this.dataMapProvider.builder(type);
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        this.gather();
        return CompletableFuture.allOf(this.itemTagsProvider.run(pOutput), this.dataMapProvider.run(pOutput));
    }

    public String getName() {
        return "Clay Soldier Provider";
    }

    private static class CustomItemTagsProvider
    extends IntrinsicHolderTagsProvider<Item> {
        private final CompletableFuture<HolderLookup.Provider> lookupProviderCopy;

        private CustomItemTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookUpProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(packOutput, Registries.ITEM, lookUpProvider, item -> item.builtInRegistryHolder().key(), modId, existingFileHelper);
            this.lookupProviderCopy = lookUpProvider;
        }

        private IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> getTag(TagType type) {
            return this.tag(type.tag);
        }

        private IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> getTag(TagKey<Item> key) {
            return this.tag(key);
        }

        protected void addTags(HolderLookup.Provider pProvider) {
        }

        protected CompletableFuture<HolderLookup.Provider> createContentsProvider() {
            return this.lookupProviderCopy.thenApply(provider -> provider);
        }
    }

    protected static enum TagType {
        HOLDABLE(ModTags.Items.SOLDIER_HOLDABLE),
        WEAPON(ModTags.Items.SOLDIER_WEAPON),
        ARMOR(ModTags.Items.SOLDIER_ARMOR);

        private final TagKey<Item> tag;

        private TagType(TagKey<Item> tag) {
            this.tag = tag;
        }
    }

    public static interface ItemTagHolder {
        public TagKey<Item> getTag();
    }
}

