/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datagen.tags;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.init.ModDamageTypes;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.init.ModPoiTypes;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.tags.EnchantmentTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.PoiTypeTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public final class ModTagProvider {
    public static List<TagsProvider<?>> getTagProviders(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
        return List.of(new DamageTypeTagProvider(output, provider, existingFileHelper), new EntityTypeTagProvider(output, provider, existingFileHelper), new EnchantmentTagProvider(output, provider, existingFileHelper), new SoldierPropertyTypeTagProvider(output, provider, existingFileHelper), new PoiTypeTagProvider(output, provider, existingFileHelper));
    }

    private static class DamageTypeTagProvider
    extends DamageTypeTagsProvider {
        public DamageTypeTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture, @Nullable ExistingFileHelper existingFileHelper) {
            super(packOutput, completableFuture, "csr", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider pProvider) {
            this.tag(ModTags.DamageTypes.CLAY_SOLDIER_DAMAGE).add(ModDamageTypes.CLAY_HURT).add(ModDamageTypes.CLAY_ON_FIRE).add(new ResourceKey[]{DamageTypes.THROWN, DamageTypes.THORNS}).addTag(DamageTypeTags.IS_EXPLOSION).addOptional(NeoForgeMod.POISON_DAMAGE.location());
        }
    }

    private static class EntityTypeTagProvider
    extends EntityTypeTagsProvider {
        public EntityTypeTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture, @Nullable ExistingFileHelper existingFileHelper) {
            super(packOutput, completableFuture, "csr", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider pProvider) {
            this.tag(EntityTypeTags.UNDEAD).add((Object[])new EntityType[]{ModEntityTypes.ZOMBIE_CLAY_SOLDIER_ENTITY.get(), ModEntityTypes.VAMPIRE_CLAY_SOLDIER_ENTITY.get()});
            this.tag(ModTags.EntityTypes.CLAY_BOSS).add(ModEntityTypes.BOSS_CLAY_SOLDIER_ENTITY.get());
        }
    }

    private static class EnchantmentTagProvider
    extends EnchantmentTagsProvider {
        public EnchantmentTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "csr", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(ModTags.Enchantments.SOLDIER_SLINGSHOT_EXCLUSIVE).add(Enchantments.PIERCING);
        }
    }

    private static class SoldierPropertyTypeTagProvider
    extends IntrinsicHolderTagsProvider<SoldierPropertyType<?>> {
        public SoldierPropertyTypeTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, ModRegistries.SOLDIER_PROPERTY_TYPES, lookupProvider, SoldierPropertyTypeTagProvider::keyExtractor, "csr", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(ModTags.SoldierPropertyTypes.REQUIRES_OWNER).add((Object)SoldierPropertyTypes.TELEPORT_TO_OWNER.get());
        }

        private static ResourceKey<SoldierPropertyType<?>> keyExtractor(SoldierPropertyType<?> type) {
            ResourceLocation res = ModRegistries.SOLDIER_PROPERTY_TYPES_REGISTRY.getKey(type);
            if (res == null) {
                ClaySoldiersCommon.LOGGER.error("Cannot create Tag with an Unregistered Property");
                throw new IllegalArgumentException("Cannot create Tag with an Unregistered Property");
            }
            return ResourceKey.create(ModRegistries.SOLDIER_PROPERTY_TYPES, (ResourceLocation)res);
        }
    }

    private static class PoiTypeTagProvider
    extends PoiTypeTagsProvider {
        public PoiTypeTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, provider, "csr", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(ModTags.PoiTypes.SOLDIER_CONTAINER).add(ModPoiTypes.HAMSTER_WHEEL_POI_KEY);
        }
    }
}

