/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.bumblebee.claysoldiers.soldierproperties.translation.KeyableTranslatableProperty;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EquipmentSlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SoldierEquipmentSlot implements StringRepresentable,
KeyableTranslatableProperty
{
    MAINHAND(Type.HAND, 0, 0, "mainhand"),
    OFFHAND(Type.HAND, 1, 5, "offhand"),
    FEET(Type.ARMOR, 0, 1, "feet"),
    LEGS(Type.ARMOR, 1, 2, "legs"),
    CHEST(Type.ARMOR, 2, 3, "chest"),
    HEAD(Type.ARMOR, 3, 4, "head"),
    CAPE(Type.ARMOR, 4, 6, "cape"),
    BACKPACK(Type.BACKPACK, 0, 7, "backpack"),
    BACKPACK_PASSIVE(Type.BACKPACK, 1, 8, "backpack_passive");

    public static final String SOLDIER_SLOT_PREFIX = "clay_soldier.slot.csr.";
    public static final List<SoldierEquipmentSlot> HANDS;
    public static final List<SoldierEquipmentSlot> BACKPACK_SLOTS;
    public static final List<SoldierEquipmentSlot> NO_SLOT;
    public static final List<SoldierEquipmentSlot> CUSTOM_EQUIP;
    public static final Codec<SoldierEquipmentSlot> CODEC;
    public static final StreamCodec<FriendlyByteBuf, SoldierEquipmentSlot> STREAM_CODEC;
    public static final StreamCodec<FriendlyByteBuf, List<SoldierEquipmentSlot>> LIST_STREAM_CODEC;
    public static final StreamCodec<ByteBuf, Optional<SoldierEquipmentSlot>> OPTIONAL_STREAM_CODEC;
    private final Type type;
    private final int index;
    private final int filterFlag;
    private final String name;
    public static final MapCodec<List<SoldierEquipmentSlot>> CODEC_MAPPED;

    private SoldierEquipmentSlot(Type pType, int pIndex, int pFilterFlag, String pName) {
        this.type = pType;
        this.index = pIndex;
        this.filterFlag = pFilterFlag;
        this.name = pName;
    }

    @Override
    public String translatableKey() {
        return SOLDIER_SLOT_PREFIX + this.getSerializedName();
    }

    public Type getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public int getFilterFlag() {
        return this.filterFlag;
    }

    public String getName() {
        return this.name;
    }

    public boolean isArmor() {
        return this.type == Type.ARMOR;
    }

    public String getSerializedName() {
        return this.name;
    }

    public static Optional<SoldierEquipmentSlot> getFromSlot(EquipmentSlot slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case EquipmentSlot.HEAD -> Optional.of(HEAD);
            case EquipmentSlot.CHEST -> Optional.of(CHEST);
            case EquipmentSlot.LEGS -> Optional.of(LEGS);
            case EquipmentSlot.FEET -> Optional.of(FEET);
            case EquipmentSlot.MAINHAND -> Optional.of(MAINHAND);
            case EquipmentSlot.OFFHAND -> Optional.of(OFFHAND);
            case EquipmentSlot.BODY -> Optional.empty();
        };
    }

    @Nullable
    public static EquipmentSlot convertToSlot(SoldierEquipmentSlot soldierEquipmentSlot) {
        return switch (soldierEquipmentSlot.ordinal()) {
            case 5 -> EquipmentSlot.HEAD;
            case 4 -> EquipmentSlot.CHEST;
            case 3 -> EquipmentSlot.LEGS;
            case 2 -> EquipmentSlot.FEET;
            case 0 -> EquipmentSlot.MAINHAND;
            case 1 -> EquipmentSlot.OFFHAND;
            default -> null;
        };
    }

    static {
        HANDS = List.of(MAINHAND, OFFHAND);
        BACKPACK_SLOTS = List.of(BACKPACK, BACKPACK_PASSIVE);
        NO_SLOT = List.of();
        CUSTOM_EQUIP = NO_SLOT;
        CODEC = StringRepresentable.fromEnum(SoldierEquipmentSlot::values);
        STREAM_CODEC = CodecUtils.createEnumStreamCodec(SoldierEquipmentSlot.class);
        LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());
        OPTIONAL_STREAM_CODEC = new StreamCodec<ByteBuf, Optional<SoldierEquipmentSlot>>(){

            public Optional<SoldierEquipmentSlot> decode(ByteBuf byteBuf) {
                byte i = byteBuf.readByte();
                return i == -1 ? Optional.empty() : Optional.of(SoldierEquipmentSlot.values()[i]);
            }

            public void encode(ByteBuf o, Optional<SoldierEquipmentSlot> soldierEquipmentSlot) {
                o.writeByte(soldierEquipmentSlot.map(Enum::ordinal).orElse(-1).intValue());
            }
        };
        CODEC_MAPPED = Codec.mapEither((MapCodec)CustomSlotType.CODEC.fieldOf("slot"), CodecUtils.singularOrPluralCodecOptional(CODEC, "slot")).xmap(CustomSlotType::getFromEither, CustomSlotType::createEither);
    }

    public static enum Type {
        HAND,
        ARMOR,
        BACKPACK;

    }

    private static enum CustomSlotType implements StringRepresentable
    {
        CUSTOM_PICK_UP("capability_pick_up", List.of()),
        HANDS("hands", HANDS),
        BACK_PACKS("backpacks", BACKPACK_SLOTS);

        public static final Codec<CustomSlotType> CODEC;
        private final String serializedName;
        private final List<SoldierEquipmentSlot> slots;

        private CustomSlotType(String serializedName, List<SoldierEquipmentSlot> slots) {
            this.serializedName = serializedName;
            this.slots = slots;
        }

        @NotNull
        public String getSerializedName() {
            return this.serializedName;
        }

        private static List<SoldierEquipmentSlot> getFromEither(Either<CustomSlotType, Set<SoldierEquipmentSlot>> either) {
            if (either.left().isPresent()) {
                return ((CustomSlotType)((Object)either.left().get())).slots;
            }
            return ((Set)either.right().orElseThrow()).stream().toList();
        }

        private static Either<CustomSlotType, Set<SoldierEquipmentSlot>> createEither(List<SoldierEquipmentSlot> slots) {
            if (slots.isEmpty()) {
                return Either.left((Object)((Object)CUSTOM_PICK_UP));
            }
            if (slots.size() != 2) {
                return Either.right(Set.copyOf(slots));
            }
            if (slots.get(0) == MAINHAND && slots.get(1) == OFFHAND || slots.get(0) == OFFHAND && slots.get(1) == MAINHAND) {
                return Either.left((Object)((Object)HANDS));
            }
            return Either.right(Set.copyOf(slots));
        }

        static {
            CODEC = StringRepresentable.fromEnum(CustomSlotType::values);
        }
    }
}

