/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap.armor;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.armor.ClientWearableRenderer;
import net.bumblebee.claysoldiers.datamap.armor.SoldierWearableEffect;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.component.DyedItemColor;

public class ClientSoldierWearableEffect
extends SoldierWearableEffect
implements ClientWearableRenderer {
    private static final Map<SoldierEquipmentSlot, ArmorItem> DEFAULT_MAP = new EnumMap<SoldierEquipmentSlot, ArmorItem>(SoldierEquipmentSlot.class);
    private ItemStack armorStack;
    private List<SoldierWearableEffect.TrimHolder> finishedArmorTrims;

    public ClientSoldierWearableEffect(ArmorItem item, ColorHelper color, Set<SoldierWearableEffect.SoldierArmorTrim> trims, boolean offsetColor) {
        super(item, color, trims, offsetColor);
    }

    public static SoldierWearableEffect create(ArmorItem item, ColorHelper color, Set<SoldierWearableEffect.SoldierArmorTrim> trims, boolean offsetColor) {
        return new ClientSoldierWearableEffect(item, color, trims, offsetColor);
    }

    public ArmorItem defaultModel(SoldierEquipmentSlot slot) {
        return DEFAULT_MAP.get(slot);
    }

    @Override
    public ItemStack getArmorCopyStack() {
        if (this.armorStack != null) {
            return this.armorStack;
        }
        ArmorItem copyModel = this.copyModel();
        if (copyModel == null) {
            return ItemStack.EMPTY;
        }
        this.armorStack = copyModel.getDefaultInstance();
        if (this.armorStack.is(ItemTags.DYEABLE) && !this.getColorHelper().equals(ColorHelper.EMPTY)) {
            this.armorStack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(this.getColorHelper().getColorStatic(), false));
        }
        return this.armorStack;
    }

    @Override
    public Iterable<SoldierWearableEffect.TrimHolder> getArmorTrims(RegistryAccess access) {
        if (this.finishedArmorTrims != null) {
            return this.finishedArmorTrims;
        }
        this.finishedArmorTrims = new ArrayList<SoldierWearableEffect.TrimHolder>();
        for (SoldierWearableEffect.SoldierArmorTrim trim : this.trims) {
            ArmorTrim armorTrim = trim.createTrim(access);
            if (armorTrim == null) continue;
            this.finishedArmorTrims.add(new SoldierWearableEffect.TrimHolder(armorTrim, trim.getColor()));
        }
        return this.finishedArmorTrims;
    }

    static {
        DEFAULT_MAP.put(SoldierEquipmentSlot.HEAD, (ArmorItem)Items.IRON_HELMET);
        DEFAULT_MAP.put(SoldierEquipmentSlot.CHEST, (ArmorItem)Items.IRON_CHESTPLATE);
        DEFAULT_MAP.put(SoldierEquipmentSlot.LEGS, (ArmorItem)Items.IRON_LEGGINGS);
        DEFAULT_MAP.put(SoldierEquipmentSlot.FEET, (ArmorItem)Items.IRON_BOOTS);
    }
}

