/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClaySoldierInventoryQuery;
import net.bumblebee.claysoldiers.datamap.armor.SoldierWearableEffect;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimPattern;

public interface ClientWearableRenderer {
    default public void renderTrims(LivingEntity livingEntity, TextureAtlas atlas, Holder<ArmorMaterial> material, PoseStack stack, MultiBufferSource bufferSource, int packedLight, Model model, boolean sprite, float partialTicks) {
        for (SoldierWearableEffect.TrimHolder pair : this.getArmorTrims(livingEntity.registryAccess())) {
            ClientWearableRenderer.renderTrim(atlas, material, stack, bufferSource, pair.trim(), packedLight, model, sprite, FastColor.ARGB32.color((int)255, (int)pair.color().getColor(livingEntity, partialTicks)));
        }
    }

    public static void renderTrim(TextureAtlas atlas, Holder<ArmorMaterial> material, PoseStack stack, MultiBufferSource bufferSource, ArmorTrim trim, int packedLight, Model model, boolean sprite, int color) {
        TextureAtlasSprite textureatlassprite = atlas.getSprite(sprite ? trim.innerTexture(material) : trim.outerTexture(material));
        VertexConsumer vertexconsumer = textureatlassprite.wrap(bufferSource.getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)trim.pattern().value()).decal())));
        model.renderToBuffer(stack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
    }

    public static void renderGlint(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, Model buffer) {
        buffer.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.armorEntityGlint()), packedLight, OverlayTexture.NO_OVERLAY);
    }

    public static void renderModel(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, Model model, int color, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)armorResource));
        if (color > 0 && color <= 0xFFFFFF) {
            color -= 0x1000000;
        }
        model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
    }

    default public int getColor(ClaySoldierInventoryQuery soldier, float partialTicks) {
        ColorHelper offsetColor = ColorHelper.EMPTY;
        if (this.isAffectedByOffsetColor()) {
            offsetColor = soldier.getOffsetColor();
        }
        if (offsetColor.isEmpty()) {
            offsetColor = this.getColorHelper();
        }
        return soldier.unpackDynamicColor(offsetColor, partialTicks);
    }

    public ColorHelper getColorHelper();

    public boolean isAffectedByOffsetColor();

    public ItemStack getArmorCopyStack();

    public Iterable<SoldierWearableEffect.TrimHolder> getArmorTrims(RegistryAccess var1);
}

