/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap.armor.accessories.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.armor.accessories.IAccessoryRenderLayer;
import net.bumblebee.claysoldiers.datamap.armor.accessories.RenderableAccessory;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class CapeRenderable
implements RenderableAccessory {
    public static final Codec<CapeRenderable> CODEC = RecordCodecBuilder.create(in -> in.group((App)ResourceLocation.CODEC.fieldOf("texture_location").forGetter(c -> c.textureLocation), (App)ColorHelper.CODEC.optionalFieldOf("color", (Object)ColorHelper.EMPTY).forGetter(c -> c.color), (App)Codec.BOOL.optionalFieldOf("affectedByOffsetColor", (Object)true).forGetter(c -> c.affectedByOffsetColor)).apply((Applicative)in, CapeRenderable::new));
    public static final StreamCodec<ByteBuf, CapeRenderable> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, c -> c.textureLocation, ColorHelper.STREAM_CODEC, c -> c.color, (StreamCodec)ByteBufCodecs.BOOL, c -> c.affectedByOffsetColor, CapeRenderable::new);
    private final ResourceLocation textureLocation;
    private final ColorHelper color;
    private final boolean affectedByOffsetColor;

    public CapeRenderable(ResourceLocation textureLocation) {
        this(textureLocation, ColorHelper.EMPTY, true);
    }

    public CapeRenderable(ResourceLocation textureLocation, ColorHelper color, boolean affectedByOffsetColor) {
        this.textureLocation = textureLocation;
        this.color = color;
        this.affectedByOffsetColor = affectedByOffsetColor;
    }

    @Override
    public void render(IAccessoryRenderLayer renderedFrom, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, AbstractClaySoldierEntity claySoldier, float pPartialTick, boolean isFalling) {
        ItemStack itemstack;
        if (this.textureLocation != null && !(itemstack = claySoldier.getItemBySlot(SoldierEquipmentSlot.CHEST).stack()).is(Items.ELYTRA)) {
            pPoseStack.pushPose();
            pPoseStack.translate(0.0f, 0.0f, 0.125f);
            double d0 = Mth.lerp((double)pPartialTick, (double)claySoldier.xCloakO, (double)claySoldier.xCloak) - Mth.lerp((double)pPartialTick, (double)claySoldier.xo, (double)claySoldier.getX());
            double d1 = Mth.lerp((double)pPartialTick, (double)claySoldier.yCloakO, (double)claySoldier.yCloak) - Mth.lerp((double)pPartialTick, (double)claySoldier.yo, (double)claySoldier.getY());
            double d2 = Mth.lerp((double)pPartialTick, (double)claySoldier.zCloakO, (double)claySoldier.zCloak) - Mth.lerp((double)pPartialTick, (double)claySoldier.zo, (double)claySoldier.getZ());
            float f = Mth.rotLerp((float)pPartialTick, (float)claySoldier.yBodyRotO, (float)claySoldier.yBodyRot);
            double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
            double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)d1 * 10.0f;
            f1 = Mth.clamp((float)f1, (float)-6.0f, (float)32.0f);
            float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
            f2 = Mth.clamp((float)f2, (float)0.0f, (float)150.0f);
            float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            f3 = Mth.clamp((float)f3, (float)-20.0f, (float)20.0f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = Mth.lerp((float)pPartialTick, (float)claySoldier.oBob, (float)claySoldier.bob);
            f1 += Mth.sin((float)(Mth.lerp((float)pPartialTick, (float)claySoldier.walkDistO, (float)claySoldier.walkDist) * 6.0f)) * 32.0f * f4;
            if (claySoldier.isCrouching()) {
                f1 += 25.0f;
            }
            pPoseStack.mulPose(Axis.XP.rotationDegrees(6.0f + f2 / 2.0f + f1));
            pPoseStack.mulPose(Axis.ZP.rotationDegrees(f3 / 2.0f));
            pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f - f3 / 2.0f));
            VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entitySolid((ResourceLocation)this.textureLocation));
            int offsetColor = this.getColor(claySoldier, pPartialTick);
            if (claySoldier.isInSittingPose()) {
                pPoseStack.translate(0.0, 0.5, 0.0);
                if (claySoldier.getId() % 2 == 1) {
                    pPoseStack.translate(0.0, 0.25, -0.2);
                }
            }
            renderedFrom.getCapeModel().renderToBuffer(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, offsetColor);
            pPoseStack.popPose();
        }
    }

    private boolean affectByOffsetColor() {
        return this.affectedByOffsetColor;
    }

    private int getColor(AbstractClaySoldierEntity soldier, float partialTick) {
        ColorHelper offsetColor = ColorHelper.EMPTY;
        if (this.affectByOffsetColor()) {
            offsetColor = soldier.getOffsetColor();
        }
        if (offsetColor.isEmpty()) {
            offsetColor = this.color;
        }
        return soldier.unpackDynamicColor(offsetColor, partialTick);
    }
}

